/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model.codeclimate;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.codeclimate.CodeClimate;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateCategory;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateLines;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateLocation;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateSeverity;

public class CodeClimateTransformer {
    public static List<CodeClimate> fromViolations(Set<Violation> from) {
        return from.stream().map(violation -> CodeClimateTransformer.toCodeClimate(violation)).collect(Collectors.toList());
    }

    private static CodeClimate toCodeClimate(Violation v) {
        String description = v.getMessage();
        String fingerprint = CodeClimateTransformer.toHash(v);
        CodeClimateLines lines = new CodeClimateLines(v.getStartLine());
        CodeClimateLocation location = new CodeClimateLocation(v.getFile(), lines, null);
        CodeClimateSeverity severity = CodeClimateTransformer.toSeverity(v.getSeverity());
        String check_name = v.getRule().isEmpty() ? v.getReporter() : v.getRule();
        String engine_name = v.getReporter();
        ArrayList<CodeClimateCategory> categories = new ArrayList<CodeClimateCategory>();
        categories.add(CodeClimateCategory.BUGRISK);
        return new CodeClimate(description, fingerprint, location, severity, check_name, engine_name, categories);
    }

    private static CodeClimateSeverity toSeverity(SEVERITY severity) {
        if (severity == SEVERITY.ERROR) {
            return CodeClimateSeverity.critical;
        }
        if (severity == SEVERITY.WARN) {
            return CodeClimateSeverity.minor;
        }
        return CodeClimateSeverity.info;
    }

    private static String toHash(Violation v) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return "No Hash: " + e.getMessage();
        }
        String fingerprintString = v.getColumn() + v.getFile() + v.getMessage() + (Object)((Object)v.getParser()) + v.getReporter() + v.getRule() + v.getCategory() + (Object)((Object)v.getSeverity()) + v.getSource() + v.getGroup();
        byte[] encodedhash = digest.digest(fingerprintString.getBytes(StandardCharsets.UTF_8));
        StringBuffer hexString = new StringBuffer();
        for (byte element : encodedhash) {
            String hex = String.format("%02X", element);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString().toLowerCase(Locale.ENGLISH);
    }
}

