/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.config;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import ru.yandex.qatools.embed.postgresql.Command;
import ru.yandex.qatools.embed.postgresql.config.SupportConfig;
import ru.yandex.qatools.embed.postgresql.ext.SubdirTempDir;

public abstract class AbstractPostgresConfig<C extends AbstractPostgresConfig>
extends ExecutableProcessConfig {
    private final Storage storage;
    protected final Net network;
    protected final Timeout timeout;
    protected final Credentials credentials;
    protected List<String> args = new ArrayList<String>();
    protected List<String> additionalInitDbParams = new ArrayList<String>();

    protected AbstractPostgresConfig(AbstractPostgresConfig config, Command postgres) {
        this(config.version, config.net(), config.storage, config.timeout(), config.credentials, new SupportConfig(postgres));
    }

    protected AbstractPostgresConfig(AbstractPostgresConfig config) {
        this(config, Command.Postgres);
    }

    public AbstractPostgresConfig(IVersion version, Net network, Storage storage, Timeout timeout, Credentials cred, SupportConfig supportConfig) {
        super(version, (ISupportConfig)supportConfig);
        this.network = network;
        this.timeout = timeout;
        this.storage = storage;
        this.credentials = cred;
    }

    public AbstractPostgresConfig(IVersion version, Net network, Storage storage, Timeout timeout) {
        this(version, network, storage, timeout, null, new SupportConfig(Command.Postgres));
    }

    public Net net() {
        return this.network;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public Storage storage() {
        return this.storage;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public List<String> args() {
        return this.args;
    }

    public C withArgs(String ... args) {
        this.args().addAll(Arrays.asList(args));
        return (C)((Object)this);
    }

    public C withAdditionalInitDbParams(List<String> additionalInitDbParams) {
        this.additionalInitDbParams.addAll(additionalInitDbParams);
        return (C)((Object)this);
    }

    public List<String> getAdditionalInitDbParams() {
        return this.additionalInitDbParams;
    }

    public String toString() {
        return "AbstractPostgresConfig{storage=" + this.storage + ", network=" + this.network + ", timeout=" + this.timeout + ", credentials=" + this.credentials + ", args=" + this.args + ", additionalInitDbParams=" + this.additionalInitDbParams + '}';
    }

    public static class Timeout {
        private final long startupTimeout;

        public Timeout() {
            this(15000L);
        }

        public Timeout(long startupTimeout) {
            this.startupTimeout = startupTimeout;
        }

        public long startupTimeout() {
            return this.startupTimeout;
        }

        public String toString() {
            return "Timeout{startupTimeout=" + this.startupTimeout + '}';
        }
    }

    public static class Net {
        private final String host;
        private final int port;

        public Net() throws IOException {
            this(Network.getLocalHost().getHostAddress(), Network.getFreeServerPort());
        }

        public Net(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int port() {
            return this.port;
        }

        public String host() {
            return this.host;
        }

        public String toString() {
            return "Net{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }

    public static class Credentials {
        private final String username;
        private final String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public String toString() {
            return "Credentials{username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
        }
    }

    public static class Storage {
        private final File dbDir;
        private final String dbName;
        private final boolean isTmpDir;

        public Storage(String dbName) throws IOException {
            this(dbName, null);
        }

        public Storage(String dbName, String databaseDir) throws IOException {
            this.dbName = dbName;
            if (StringUtils.isEmpty((CharSequence)databaseDir)) {
                this.isTmpDir = true;
                this.dbDir = Files.createTempDir((IDirectory)SubdirTempDir.defaultInstance(), (String)"db-content");
            } else {
                this.dbDir = Files.createOrCheckDir((String)databaseDir);
                this.isTmpDir = false;
            }
        }

        public File dbDir() {
            return this.dbDir;
        }

        public boolean isTmpDir() {
            return this.isTmpDir;
        }

        public String dbName() {
            return this.dbName;
        }

        public String toString() {
            return "Storage{dbDir=" + this.dbDir + ", dbName='" + this.dbName + '\'' + ", isTmpDir=" + this.isTmpDir + '}';
        }
    }
}

