/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util.walk;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.vyarus.java.generics.resolver.util.GenericsResolutionUtils;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.IgnoreGenericsMap;
import ru.vyarus.java.generics.resolver.util.walk.TypesVisitor;

public final class TypesWalker {
    private static final IgnoreGenericsMap IGNORE_VARS = IgnoreGenericsMap.getInstance();

    private TypesWalker() {
    }

    public static void walk(Type one, Type two, TypesVisitor visitor) {
        IgnoreGenericsMap oneKnownGenerics = new IgnoreGenericsMap((Map<? extends String, ? extends Type>)GenericsResolutionUtils.resolveGenerics(one, IGNORE_VARS));
        IgnoreGenericsMap twoKnownGenerics = new IgnoreGenericsMap((Map<? extends String, ? extends Type>)GenericsResolutionUtils.resolveGenerics(two, IGNORE_VARS));
        TypesWalker.doWalk(GenericsUtils.resolveTypeVariables(one, (Map<String, Type>)oneKnownGenerics), oneKnownGenerics, GenericsUtils.resolveTypeVariables(two, (Map<String, Type>)twoKnownGenerics), twoKnownGenerics, visitor);
    }

    private static void doWalk(Type one, Map<String, Type> oneKnownGenerics, Type two, Map<String, Type> twoKnownGenerics, TypesVisitor visitor) {
        Class<?> oneType = TypeUtils.wrapPrimitive(GenericsUtils.resolveClass(one, IGNORE_VARS));
        Class<?> twoType = TypeUtils.wrapPrimitive(GenericsUtils.resolveClass(two, IGNORE_VARS));
        if (!TypesWalker.isCompatible(one, two)) {
            visitor.incompatibleHierarchy(one, two);
        } else if (visitor.next(one, two) && oneType != Object.class && twoType != Object.class) {
            if (oneType.isArray()) {
                TypesWalker.doWalk(TypesWalker.arrayType(one), oneKnownGenerics, TypesWalker.arrayType(two), twoKnownGenerics, visitor);
            } else if (oneType.getTypeParameters().length > 0 || twoType.getTypeParameters().length > 0) {
                TypesWalker.visitGenerics(one, oneType, oneKnownGenerics, two, twoType, twoKnownGenerics, visitor);
            }
        }
    }

    private static void visitGenerics(Type one, Class<?> oneType, Map<String, Type> oneKnownGenerics, Type two, Class<?> twoType, Map<String, Type> twoKnownGenerics, TypesVisitor visitor) {
        boolean oneLower = oneType.isAssignableFrom(twoType);
        Class<?> lowerClass = oneLower ? oneType : twoType;
        Class<?> upperClass = oneLower ? twoType : oneType;
        Type lowerType = oneLower ? one : two;
        Type upperType = oneLower ? two : one;
        Map<String, Type> lowerKnownGenerics = oneLower ? oneKnownGenerics : twoKnownGenerics;
        Map<String, Type> upperKnownGenerics = oneLower ? twoKnownGenerics : oneKnownGenerics;
        LinkedHashMap<String, Type> lowerGenerics = GenericsResolutionUtils.resolveGenerics(lowerType, lowerKnownGenerics);
        Map<String, Type> upperGenerics = TypesWalker.resolveUpperGenerics(lowerType, lowerClass, lowerKnownGenerics, upperType, upperClass, upperKnownGenerics);
        Map<String, Type> oneGenerics = oneLower ? lowerGenerics : upperGenerics;
        Map<String, Type> twoGenerics = oneLower ? upperGenerics : lowerGenerics;
        for (Map.Entry<String, Type> entry : GenericsUtils.extractTypeGenerics(oneLower ? oneType : twoType, oneGenerics).entrySet()) {
            String generic = entry.getKey();
            TypesWalker.doWalk(entry.getValue(), oneKnownGenerics, twoGenerics.get(generic), twoKnownGenerics, visitor);
        }
    }

    private static boolean isCompatible(Type one, Type two) {
        Class[] oneBounds = GenericsUtils.resolveUpperBounds(one, IGNORE_VARS);
        Class[] twoBounds = GenericsUtils.resolveUpperBounds(two, IGNORE_VARS);
        boolean res = true;
        boolean oneWildcard = one instanceof WildcardType;
        boolean twoWildcard = two instanceof WildcardType;
        if (oneWildcard || twoWildcard) {
            if (oneWildcard && twoWildcard) {
                res = TypesWalker.isLowerBoundsCompatible((WildcardType)one, (WildcardType)two);
            }
            if (res && oneWildcard) {
                res = TypesWalker.isLowerBoundCompatible((WildcardType)one, twoBounds);
            }
            if (res && twoWildcard) {
                res = TypesWalker.isLowerBoundCompatible((WildcardType)two, oneBounds);
            }
            if (res) {
                res = TypeUtils.isAssignableBounds(oneBounds, twoBounds) || TypeUtils.isAssignableBounds(twoBounds, oneBounds);
            }
        } else {
            res = TypesWalker.isCompatibleClasses(oneBounds[0], twoBounds[0]);
        }
        return res;
    }

    private static boolean isCompatibleClasses(Class<?> one, Class<?> two) {
        return one.isAssignableFrom(two) || two.isAssignableFrom(one);
    }

    private static boolean isLowerBoundsCompatible(WildcardType one, WildcardType two) {
        boolean res = true;
        Type[] oneLower = one.getLowerBounds();
        Type[] twoLower = two.getLowerBounds();
        if (oneLower.length > 0 && twoLower.length > 0) {
            res = TypesWalker.isCompatible(GenericsUtils.resolveClass(oneLower[0], IGNORE_VARS), GenericsUtils.resolveClass(twoLower[0], IGNORE_VARS));
        }
        return res;
    }

    private static boolean isLowerBoundCompatible(WildcardType type, Class ... with) {
        boolean res = true;
        if (type.getLowerBounds().length > 0) {
            Class<?> lower = GenericsUtils.resolveClass(type.getLowerBounds()[0], IGNORE_VARS);
            for (Class target : with) {
                if (target.isAssignableFrom(lower)) continue;
                res = false;
                break;
            }
        }
        return res;
    }

    private static Type arrayType(Type type) {
        return GenericsUtils.resolveTypeVariables(type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType(), (Map<String, Type>)IGNORE_VARS);
    }

    private static Map<String, Type> resolveUpperGenerics(Type lowerType, Class<?> lowerClass, Map<String, Type> lowerKnownGenerics, Type upperType, Class<?> upperClass, Map<String, Type> upperKnownGenerics) {
        Map<String, Type> res = lowerType.equals(upperType) ? GenericsResolutionUtils.resolveGenerics(upperType, upperKnownGenerics) : (Map)GenericsResolutionUtils.resolve(upperClass, GenericsResolutionUtils.resolveGenerics(upperType, lowerKnownGenerics), Collections.<Class<?>, LinkedHashMap<String, Type>>emptyMap(), Collections.<Class<?>>emptyList()).get(lowerClass);
        return res;
    }
}

