/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util.walk;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.IgnoreGenericsMap;
import ru.vyarus.java.generics.resolver.util.walk.TypesVisitor;

public class AssignabilityTypesVisitor
implements TypesVisitor {
    private static final IgnoreGenericsMap IGNORE = IgnoreGenericsMap.getInstance();
    private boolean assignable = true;

    @Override
    public boolean next(Type one, Type two) {
        if (two != Object.class) {
            Class[] oneBounds = GenericsUtils.resolveUpperBounds(one, IGNORE);
            Class[] twoBounds = GenericsUtils.resolveUpperBounds(two, IGNORE);
            this.assignable = TypeUtils.isAssignableBounds(oneBounds, twoBounds);
            this.assignable = this.assignable && this.checkLowerBounds(one, two);
        }
        return this.assignable;
    }

    @Override
    public void incompatibleHierarchy(Type one, Type two) {
        this.assignable = false;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    private boolean checkLowerBounds(Type one, Type two) {
        boolean res = this.notLowerBounded(one) ? true : (this.notLowerBounded(two) ? false : TypeUtils.isMoreSpecific(((WildcardType)two).getLowerBounds()[0], ((WildcardType)one).getLowerBounds()[0]));
        return res;
    }

    private boolean notLowerBounded(Type type) {
        return !(type instanceof WildcardType) || ((WildcardType)type).getLowerBounds().length == 0;
    }
}

