/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GenericsInfo {
    private final Class<?> root;
    private final Map<Class<?>, LinkedHashMap<String, Type>> types;

    public GenericsInfo(Class<?> root, Map<Class<?>, LinkedHashMap<String, Type>> types) {
        this.root = root;
        this.types = types;
    }

    public Class<?> getRootClass() {
        return this.root;
    }

    public Map<String, Type> getTypeGenerics(Class<?> type) {
        if (!this.types.containsKey(type)) {
            throw new IllegalArgumentException(String.format("Type %s is not assignable from %s", type.getName(), this.root.getName()));
        }
        return new LinkedHashMap<String, Type>((Map)this.types.get(type));
    }

    public Set<Class<?>> getComposingTypes() {
        return new HashSet(this.types.keySet());
    }
}

