/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.context.MethodGenericsContext;
import ru.vyarus.java.generics.resolver.context.TypeGenericsContext;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.NoGenericException;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.UnknownGenericException;

public abstract class GenericsContext {
    protected final GenericsInfo genericsInfo;
    protected final Class<?> currentType;
    protected final Map<String, Type> typeGenerics;

    public GenericsContext(GenericsInfo genericsInfo, Class<?> type) {
        this.genericsInfo = genericsInfo;
        this.currentType = type;
        this.typeGenerics = genericsInfo.getTypeGenerics(type);
    }

    public Class<?> currentClass() {
        return this.currentType;
    }

    public List<Type> genericTypes() {
        return new ArrayList<Type>(this.typeGenerics.values());
    }

    public List<Class<?>> generics() {
        ArrayList res = new ArrayList();
        for (Type type : this.typeGenerics.values()) {
            res.add(this.resolveClass(type));
        }
        return res;
    }

    public List<String> genericsAsString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Type type : this.contextGenerics().values()) {
            res.add(this.toStringType(type));
        }
        return res;
    }

    public Type genericType(int position) {
        return this.genericTypes().get(position);
    }

    public Type genericType(String genericName) {
        return this.contextGenerics().get(this.checkGenericName(genericName));
    }

    public Class<?> generic(int position) {
        return this.resolveClass(this.genericTypes().get(position));
    }

    public Class<?> generic(String genericName) {
        return this.resolveClass(this.contextGenerics().get(this.checkGenericName(genericName)));
    }

    public String genericAsString(int position) {
        return this.toStringType(this.genericType(position));
    }

    public String genericAsString(String genericName) {
        return this.toStringType(this.contextGenerics().get(this.checkGenericName(genericName)));
    }

    public Map<String, Type> genericsMap() {
        return new LinkedHashMap<String, Type>(this.contextGenerics());
    }

    public GenericsInfo getGenericsInfo() {
        return this.genericsInfo;
    }

    public Class<?> resolveClass(Type type) {
        try {
            return GenericsUtils.resolveClass(type, this.contextGenerics());
        }
        catch (UnknownGenericException e) {
            throw e.rethrowWithType(this.currentType);
        }
    }

    public List<Class<?>> resolveGenericsOf(Type type) throws NoGenericException {
        try {
            return GenericsUtils.resolveGenericsOf(type, this.contextGenerics());
        }
        catch (UnknownGenericException e) {
            throw e.rethrowWithType(this.currentType);
        }
    }

    public Class<?> resolveGenericOf(Type type) throws NoGenericException {
        try {
            return this.resolveGenericsOf(type).get(0);
        }
        catch (UnknownGenericException e) {
            throw e.rethrowWithType(this.currentType);
        }
    }

    public String toStringType(Type type) {
        try {
            return TypeToStringUtils.toStringType(type, this.contextGenerics());
        }
        catch (UnknownGenericException e) {
            throw e.rethrowWithType(this.currentType);
        }
    }

    public TypeGenericsContext type(Class<?> type) {
        return new TypeGenericsContext(this.genericsInfo, type);
    }

    public MethodGenericsContext method(Method method) {
        return new MethodGenericsContext(this.genericsInfo, method.getDeclaringClass(), method);
    }

    protected abstract Map<String, Type> contextGenerics();

    private String checkGenericName(String genericName) {
        if (!this.contextGenerics().containsKey(genericName)) {
            throw new UnknownGenericException(this.currentType, genericName);
        }
        return genericName;
    }
}

