/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.scrollable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.Scroller;
import ru.noties.scrollable.CanScrollVerticallyDelegate;
import ru.noties.scrollable.CloseUpAlgorithm;
import ru.noties.scrollable.CloseUpAnimatorConfigurator;
import ru.noties.scrollable.CloseUpIdleAnimationTime;
import ru.noties.scrollable.DefaultCloseUpAlgorithm;
import ru.noties.scrollable.DipUtils;
import ru.noties.scrollable.GestureListenerAdapter;
import ru.noties.scrollable.InterpolatorCloseUpAnimatorConfigurator;
import ru.noties.scrollable.OnScrollChangedListener;
import ru.noties.scrollable.R;
import ru.noties.scrollable.SimpleCloseUpIdleAnimationTime;

public class ScrollableLayout
extends FrameLayout {
    private static final long DEFAULT_IDLE_CLOSE_UP_ANIMATION = 200L;
    private static final int DEFAULT_CONSIDER_IDLE_MILLIS = 100;
    private Scroller mScroller;
    private GestureDetector mScrollDetector;
    private GestureDetector mFlingDetector;
    private CanScrollVerticallyDelegate mCanScrollVerticallyDelegate;
    private OnScrollChangedListener mOnScrollChangedListener;
    private int mMaxScrollY;
    private boolean mIsScrolling;
    private boolean mIsFlinging;
    private MotionEventHook mMotionEventHook;
    private CloseUpAlgorithm mCloseUpAlgorithm;
    private ObjectAnimator mCloseUpAnimator;
    private boolean mSelfUpdateScroll;
    private boolean mSelfUpdateFling;
    private CloseUpIdleAnimationTime mCloseUpIdleAnimationTime;
    private CloseUpAnimatorConfigurator mCloseAnimatorConfigurator;
    private View mDraggableView;
    private boolean mIsDraggingDraggable;
    private final Rect mDraggableRect = new Rect();
    private long mConsiderIdleMillis;
    private final Runnable mScrollRunnable = new Runnable(){

        @Override
        public void run() {
            boolean isContinue = ScrollableLayout.this.mScroller.computeScrollOffset();
            ScrollableLayout.this.mSelfUpdateFling = isContinue;
            if (isContinue) {
                int nowY;
                int y = ScrollableLayout.this.mScroller.getCurrY();
                int diff = y - (nowY = ScrollableLayout.this.getScrollY());
                if (diff != 0) {
                    ScrollableLayout.this.scrollBy(0, diff);
                }
                ScrollableLayout.this.post(this);
            }
        }
    };
    private final Runnable mIdleRunnable = new Runnable(){

        @Override
        public void run() {
            ScrollableLayout.this.cancelIdleAnimationIfRunning(false);
            if (ScrollableLayout.this.mSelfUpdateScroll || ScrollableLayout.this.mSelfUpdateFling) {
                return;
            }
            int nowY = ScrollableLayout.this.getScrollY();
            if (nowY == 0 || nowY == ScrollableLayout.this.mMaxScrollY) {
                return;
            }
            int endY = ScrollableLayout.this.mCloseUpAlgorithm.getIdleFinalY(ScrollableLayout.this, nowY, ScrollableLayout.this.mMaxScrollY);
            if (nowY == endY) {
                return;
            }
            ScrollableLayout.this.mCloseUpAnimator = ObjectAnimator.ofInt((Object)((Object)ScrollableLayout.this), (Property)ScrollableLayout.this.mCloseUpAnimationProperty, (int[])new int[]{nowY, endY});
            long duration = ScrollableLayout.this.mCloseUpIdleAnimationTime != null ? ScrollableLayout.this.mCloseUpIdleAnimationTime.compute(ScrollableLayout.this, nowY, endY, ScrollableLayout.this.mMaxScrollY) : 200L;
            ScrollableLayout.this.mCloseUpAnimator.setDuration(duration);
            ScrollableLayout.this.mCloseUpAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    ScrollableLayout.this.mSelfUpdateScroll = true;
                }

                public void onAnimationEnd(Animator animation) {
                    ScrollableLayout.this.mSelfUpdateScroll = false;
                }

                public void onAnimationCancel(Animator animation) {
                    ScrollableLayout.this.mSelfUpdateScroll = false;
                }
            });
            if (ScrollableLayout.this.mCloseAnimatorConfigurator != null) {
                ScrollableLayout.this.mCloseAnimatorConfigurator.configure(ScrollableLayout.this.mCloseUpAnimator);
            }
            ScrollableLayout.this.mCloseUpAnimator.start();
        }
    };
    private final Property<ScrollableLayout, Integer> mCloseUpAnimationProperty = new Property<ScrollableLayout, Integer>(Integer.class, "scrollY"){

        public Integer get(ScrollableLayout object) {
            return object.getScrollY();
        }

        public void set(ScrollableLayout layout, Integer value) {
            layout.setScrollY(value);
        }
    };

    public ScrollableLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public ScrollableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ScrollableLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attributeSet) {
        TypedArray array = context.obtainStyledAttributes(attributeSet, R.styleable.ScrollableLayout);
        try {
            int interpolatorResId;
            int closeUpAnimationMillis;
            boolean flyWheel = array.getBoolean(R.styleable.ScrollableLayout_scrollable_scrollerFlywheel, false);
            this.mScroller = this.initScroller(context, null, flyWheel);
            float friction = array.getFloat(R.styleable.ScrollableLayout_scrollable_friction, Float.NaN);
            if (friction == friction) {
                this.setFriction(friction);
            }
            this.mMaxScrollY = array.getDimensionPixelSize(R.styleable.ScrollableLayout_scrollable_maxScroll, 0);
            long considerIdleMillis = array.getInteger(R.styleable.ScrollableLayout_scrollable_considerIdleMillis, 100);
            this.setConsiderIdleMillis(considerIdleMillis);
            boolean useDefaultCloseUp = array.getBoolean(R.styleable.ScrollableLayout_scrollable_defaultCloseUp, false);
            if (useDefaultCloseUp) {
                this.setCloseUpAlgorithm(new DefaultCloseUpAlgorithm());
            }
            if ((closeUpAnimationMillis = array.getInteger(R.styleable.ScrollableLayout_scrollable_closeUpAnimationMillis, -1)) != -1) {
                this.setCloseUpIdleAnimationTime(new SimpleCloseUpIdleAnimationTime(closeUpAnimationMillis));
            }
            if ((interpolatorResId = array.getResourceId(R.styleable.ScrollableLayout_scrollable_closeUpAnimatorInterpolator, 0)) != 0) {
                Interpolator interpolator = AnimationUtils.loadInterpolator((Context)context, (int)interpolatorResId);
                this.setCloseAnimatorConfigurator(new InterpolatorCloseUpAnimatorConfigurator(interpolator));
            }
        }
        finally {
            array.recycle();
        }
        this.setVerticalScrollBarEnabled(true);
        this.mScrollDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ScrollGestureListener());
        this.mFlingDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new FlingGestureListener(context));
        this.mMotionEventHook = new MotionEventHook(new MotionEventHookCallback(){

            @Override
            public void apply(MotionEvent event) {
                ScrollableLayout.super.dispatchTouchEvent(event);
            }
        });
    }

    protected Scroller initScroller(Context context, Interpolator interpolator, boolean flywheel) {
        return new Scroller(context, interpolator, flywheel);
    }

    public void setFriction(float friction) {
        this.mScroller.setFriction(friction);
    }

    public void setCanScrollVerticallyDelegate(CanScrollVerticallyDelegate delegate) {
        this.mCanScrollVerticallyDelegate = delegate;
    }

    public void setMaxScrollY(int maxY) {
        this.mMaxScrollY = maxY;
    }

    public int getMaxScrollY() {
        return this.mMaxScrollY;
    }

    public void setConsiderIdleMillis(long millis) {
        this.mConsiderIdleMillis = millis;
    }

    public long getConsiderIdleMillis() {
        return this.mConsiderIdleMillis;
    }

    public void setOnScrollChangedListener(OnScrollChangedListener listener) {
        this.mOnScrollChangedListener = listener;
    }

    public void onScrollChanged(int l, int t, int oldL, int oldT) {
        boolean changed;
        boolean bl = changed = t != oldT;
        if (changed && this.mOnScrollChangedListener != null) {
            this.mOnScrollChangedListener.onScrollChanged(t, oldT, this.mMaxScrollY);
        }
        if (this.mCloseUpAlgorithm != null) {
            this.removeCallbacks(this.mIdleRunnable);
            if (!this.mSelfUpdateScroll && changed) {
                this.postDelayed(this.mIdleRunnable, this.mConsiderIdleMillis);
            }
        }
    }

    protected void setSelfUpdateScroll(boolean value) {
        this.mSelfUpdateScroll = value;
    }

    protected boolean isSelfUpdateScroll() {
        return this.mSelfUpdateScroll;
    }

    public void setCloseUpAlgorithm(CloseUpAlgorithm closeUpAlgorithm) {
        this.mCloseUpAlgorithm = closeUpAlgorithm;
    }

    public void setCloseUpIdleAnimationTime(CloseUpIdleAnimationTime closeUpIdleAnimationTime) {
        this.mCloseUpIdleAnimationTime = closeUpIdleAnimationTime;
    }

    public void setCloseAnimatorConfigurator(CloseUpAnimatorConfigurator configurator) {
        this.mCloseAnimatorConfigurator = configurator;
    }

    public void scrollTo(int x, int y) {
        int newY = this.getNewY(y);
        if (newY < 0) {
            return;
        }
        super.scrollTo(0, newY);
    }

    protected int getNewY(int y) {
        boolean isScrollingBottomTop;
        int currentY = this.getScrollY();
        if (currentY == y) {
            return -1;
        }
        int direction = y - currentY;
        boolean bl = isScrollingBottomTop = direction < 0;
        if (this.mCanScrollVerticallyDelegate != null && (isScrollingBottomTop ? !this.mIsDraggingDraggable && !this.mSelfUpdateScroll && this.mCanScrollVerticallyDelegate.canScrollVertically(direction) : currentY == this.mMaxScrollY && !this.mCanScrollVerticallyDelegate.canScrollVertically(direction))) {
            return -1;
        }
        if (y < 0) {
            y = 0;
        } else if (y > this.mMaxScrollY) {
            y = this.mMaxScrollY;
        }
        return y;
    }

    public void setDraggableView(View view) {
        this.mDraggableView = view;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean shouldRedirectDownTouch;
        int action = event.getActionMasked();
        if (action == 0) {
            this.mScroller.abortAnimation();
            if (this.mDraggableView != null && this.mDraggableView.getGlobalVisibleRect(this.mDraggableRect)) {
                int x = (int)(event.getRawX() + 0.5f);
                int y = (int)(event.getRawY() + 0.5f);
                this.mIsDraggingDraggable = this.mDraggableRect.contains(x, y);
            } else {
                this.mIsDraggingDraggable = false;
            }
        }
        boolean isPrevScrolling = this.mIsScrolling;
        boolean isPrevFlinging = this.mIsFlinging;
        this.mIsFlinging = this.mFlingDetector.onTouchEvent(event);
        this.mIsScrolling = this.mScrollDetector.onTouchEvent(event);
        this.removeCallbacks(this.mScrollRunnable);
        this.post(this.mScrollRunnable);
        boolean isIntercepted = this.mIsScrolling || this.mIsFlinging;
        boolean isPrevIntercepted = isPrevScrolling || isPrevFlinging;
        boolean bl = shouldRedirectDownTouch = action == 2 && !isIntercepted && isPrevIntercepted && this.getScrollY() == this.mMaxScrollY;
        if (isIntercepted || isPrevIntercepted) {
            this.mMotionEventHook.hook(event, 3);
            if (!isPrevIntercepted) {
                return true;
            }
        }
        if (shouldRedirectDownTouch) {
            this.mMotionEventHook.hook(event, 0);
        }
        super.dispatchTouchEvent(event);
        return true;
    }

    private void cancelIdleAnimationIfRunning(boolean removeCallbacks) {
        if (removeCallbacks) {
            this.removeCallbacks(this.mIdleRunnable);
        }
        if (this.mCloseUpAnimator != null && this.mCloseUpAnimator.isRunning()) {
            this.mCloseUpAnimator.cancel();
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldY = this.getScrollY();
            int nowY = this.mScroller.getCurrY();
            this.scrollTo(0, nowY);
            if (oldY != nowY) {
                this.onScrollChanged(0, this.getScrollY(), 0, oldY);
            }
            this.postInvalidate();
        }
    }

    protected int computeVerticalScrollRange() {
        return this.mMaxScrollY;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childTop = top;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            view.layout(left, childTop, right, childTop + view.getMeasuredHeight());
            childTop += view.getMeasuredHeight();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        ScrollableLayoutSavedState savedState = new ScrollableLayoutSavedState(superState);
        savedState.scrollY = this.getScrollY();
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ScrollableLayoutSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ScrollableLayoutSavedState in = (ScrollableLayoutSavedState)state;
        super.onRestoreInstanceState(in.getSuperState());
        this.setScrollY(in.scrollY);
    }

    private static class ScrollableLayoutSavedState
    extends View.BaseSavedState {
        int scrollY;
        public static final Parcelable.Creator<ScrollableLayoutSavedState> CREATOR = new Parcelable.Creator<ScrollableLayoutSavedState>(){

            public ScrollableLayoutSavedState createFromParcel(Parcel in) {
                return new ScrollableLayoutSavedState(in);
            }

            public ScrollableLayoutSavedState[] newArray(int size) {
                return new ScrollableLayoutSavedState[size];
            }
        };

        public ScrollableLayoutSavedState(Parcel source) {
            super(source);
            this.scrollY = source.readInt();
        }

        public ScrollableLayoutSavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.scrollY);
        }
    }

    private static interface MotionEventHookCallback {
        public void apply(MotionEvent var1);
    }

    private static class MotionEventHook {
        final MotionEventHookCallback callback;

        MotionEventHook(MotionEventHookCallback callback) {
            this.callback = callback;
        }

        void hook(MotionEvent event, int action) {
            int historyAction = event.getAction();
            event.setAction(action);
            this.callback.apply(event);
            event.setAction(historyAction);
        }
    }

    private class FlingGestureListener
    extends GestureListenerAdapter {
        private static final int MIN_FLING_DISTANCE_DIP = 12;
        private final int mMinFlingDistance;
        private final float mMinVelocity;

        FlingGestureListener(Context context) {
            this.mMinFlingDistance = DipUtils.dipToPx(context, 12);
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.mMinVelocity = configuration.getScaledMinimumFlingVelocity();
        }

        @Override
        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (Math.abs(velocityY) < this.mMinVelocity) {
                return false;
            }
            if (Math.abs(velocityX) > Math.abs(velocityY)) {
                return false;
            }
            int nowY = ScrollableLayout.this.getScrollY();
            if (nowY < 0 || nowY > ScrollableLayout.this.mMaxScrollY) {
                return false;
            }
            ScrollableLayout.this.mScroller.fling(0, nowY, 0, -((int)(velocityY + 0.5f)), 0, 0, 0, ScrollableLayout.this.mMaxScrollY);
            if (ScrollableLayout.this.mScroller.computeScrollOffset()) {
                int finalY;
                int suggestedY = ScrollableLayout.this.mScroller.getFinalY();
                if (Math.abs(nowY - suggestedY) < this.mMinFlingDistance) {
                    ScrollableLayout.this.mScroller.abortAnimation();
                    return false;
                }
                if (suggestedY == nowY || ScrollableLayout.this.mCloseUpAlgorithm == null) {
                    finalY = suggestedY;
                } else {
                    finalY = ScrollableLayout.this.mCloseUpAlgorithm.getFlingFinalY(ScrollableLayout.this, suggestedY - nowY < 0, nowY, suggestedY, ScrollableLayout.this.mMaxScrollY);
                    ScrollableLayout.this.mScroller.setFinalY(finalY);
                }
                int newY = ScrollableLayout.this.getNewY(finalY);
                return finalY != nowY && newY >= 0;
            }
            return false;
        }
    }

    private class ScrollGestureListener
    extends GestureListenerAdapter {
        private final int mTouchSlop;

        private ScrollGestureListener() {
            ViewConfiguration vc = ViewConfiguration.get((Context)ScrollableLayout.this.getContext());
            this.mTouchSlop = vc.getScaledTouchSlop();
        }

        @Override
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            float absX = Math.abs(distanceX);
            if (absX > Math.abs(distanceY) || absX > (float)this.mTouchSlop) {
                return false;
            }
            int now = ScrollableLayout.this.getScrollY();
            ScrollableLayout.this.scrollBy(0, (int)(distanceY + 0.5f));
            return now != ScrollableLayout.this.getScrollY();
        }
    }
}

