/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.spans;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.ReplacementSpan;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import ru.noties.markwon.spans.ObjectsPool;
import ru.noties.markwon.spans.SpannableTheme;

public class TableRowSpan
extends ReplacementSpan {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private final SpannableTheme theme;
    private final List<Cell> cells;
    private final List<StaticLayout> layouts;
    private final TextPaint textPaint;
    private final boolean header;
    private final boolean odd;
    private final Rect rect = ObjectsPool.rect();
    private final Paint paint = ObjectsPool.paint();
    private int width;
    private int height;
    private Invalidator invalidator;

    public TableRowSpan(@NonNull SpannableTheme theme, @NonNull List<Cell> cells, boolean header, boolean odd) {
        this.theme = theme;
        this.cells = cells;
        this.layouts = new ArrayList<StaticLayout>(cells.size());
        this.textPaint = new TextPaint();
        this.header = header;
        this.odd = odd;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
        if (this.layouts.size() > 0 && fm != null) {
            int max = 0;
            for (StaticLayout layout : this.layouts) {
                int height = layout.getHeight();
                if (height <= max) continue;
                max = height;
            }
            this.height = max;
            int padding = this.theme.tableCellPadding() * 2;
            fm.ascent = -(max + padding);
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Canvas canvas, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        boolean drawBorder;
        if (this.recreateLayouts(canvas.getWidth())) {
            this.width = canvas.getWidth();
            this.textPaint.set(paint);
            this.makeNewLayouts();
        }
        int maxHeight = 0;
        int padding = this.theme.tableCellPadding();
        int size = this.layouts.size();
        int w = this.width / size;
        int heightDiff = (bottom - top - this.height) / 4;
        if (this.header) {
            this.theme.applyTableHeaderRowStyle(this.paint);
        } else if (this.odd) {
            this.theme.applyTableOddRowStyle(this.paint);
        } else {
            this.theme.applyTableEvenRowStyle(this.paint);
        }
        if (this.paint.getColor() != 0) {
            int save = canvas.save();
            try {
                this.rect.set(0, 0, this.width, bottom - top);
                canvas.translate(x, (float)(top - heightDiff));
                canvas.drawRect(this.rect, this.paint);
            }
            finally {
                canvas.restoreToCount(save);
            }
        }
        this.paint.set(paint);
        this.theme.applyTableBorderStyle(this.paint);
        int borderWidth = this.theme.tableBorderWidth(paint);
        boolean bl = drawBorder = borderWidth > 0;
        if (drawBorder) {
            this.rect.set(0, 0, w, bottom - top);
        }
        for (int i = 0; i < size; ++i) {
            StaticLayout layout = this.layouts.get(i);
            int save = canvas.save();
            try {
                canvas.translate(x + (float)(i * w), (float)(top - heightDiff));
                if (drawBorder) {
                    canvas.drawRect(this.rect, this.paint);
                }
                canvas.translate((float)padding, (float)(padding + heightDiff));
                layout.draw(canvas);
                if (layout.getHeight() <= maxHeight) continue;
                maxHeight = layout.getHeight();
                continue;
            }
            finally {
                canvas.restoreToCount(save);
            }
        }
        if (this.height != maxHeight && this.invalidator != null) {
            this.invalidator.invalidate();
        }
    }

    private boolean recreateLayouts(int newWidth) {
        return this.width != newWidth;
    }

    private void makeNewLayouts() {
        this.textPaint.setFakeBoldText(this.header);
        int columns = this.cells.size();
        int padding = this.theme.tableCellPadding() * 2;
        int w = this.width / columns - padding;
        this.layouts.clear();
        int size = this.cells.size();
        for (int i = 0; i < size; ++i) {
            Cell cell = this.cells.get(i);
            StaticLayout layout = new StaticLayout(cell.text, this.textPaint, w, TableRowSpan.alignment(cell.alignment), 1.0f, 0.0f, false);
            this.layouts.add(layout);
        }
    }

    @SuppressLint(value={"SwitchIntDef"})
    private static Layout.Alignment alignment(int alignment) {
        Layout.Alignment out;
        switch (alignment) {
            case 1: {
                out = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 2: {
                out = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            default: {
                out = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return out;
    }

    public TableRowSpan invalidator(Invalidator invalidator) {
        this.invalidator = invalidator;
        return this;
    }

    public static class Cell {
        final int alignment;
        final CharSequence text;

        public Cell(int alignment, CharSequence text) {
            this.alignment = alignment;
            this.text = text;
        }

        public int alignment() {
            return this.alignment;
        }

        public CharSequence text() {
            return this.text;
        }

        public String toString() {
            return "Cell{alignment=" + this.alignment + ", text=" + this.text + '}';
        }
    }

    public static interface Invalidator {
        public void invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Alignment {
    }
}

