/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.renderer.html2.tag;

import android.support.annotation.NonNull;
import ru.noties.markwon.SpannableBuilder;
import ru.noties.markwon.SpannableConfiguration;
import ru.noties.markwon.html.api.HtmlTag;
import ru.noties.markwon.renderer.html2.tag.TagHandler;

public class ListHandler
extends TagHandler {
    @Override
    public void handle(@NonNull SpannableConfiguration configuration, @NonNull SpannableBuilder builder, @NonNull HtmlTag tag) {
        if (!tag.isBlock()) {
            return;
        }
        HtmlTag.Block block = tag.getAsBlock();
        boolean ol = "ol".equals(block.name());
        boolean ul = "ul".equals(block.name());
        if (!ol && !ul) {
            return;
        }
        int number = 1;
        int bulletLevel = ListHandler.currentBulletListLevel(block);
        for (HtmlTag.Block child : block.children()) {
            ListHandler.visitChildren(configuration, builder, child);
            if (!"li".equals(child.name())) continue;
            Object spans = ol ? configuration.factory().orderedListItem(configuration.theme(), number++) : configuration.factory().bulletListItem(configuration.theme(), bulletLevel);
            SpannableBuilder.setSpans(builder, spans, child.start(), child.end());
        }
    }

    private static int currentBulletListLevel(@NonNull HtmlTag.Block block) {
        int level = 0;
        while ((block = block.parent()) != null) {
            if (!"ul".equals(block.name()) && !"ol".equals(block.name())) continue;
            ++level;
        }
        return level;
    }
}

