/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.support.annotation.NonNull;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import ru.noties.markwon.renderer.R;
import ru.noties.markwon.spans.TableRowSpan;

abstract class TableRowsScheduler {
    static void schedule(final @NonNull TextView view) {
        Object[] spans = TableRowsScheduler.extract(view);
        if (spans != null && spans.length > 0) {
            if (view.getTag(R.id.markwon_tables_scheduler) == null) {
                View.OnAttachStateChangeListener listener = new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                    }

                    public void onViewDetachedFromWindow(View v) {
                        TableRowsScheduler.unschedule(view);
                        view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        view.setTag(R.id.markwon_tables_scheduler, null);
                    }
                };
                view.addOnAttachStateChangeListener(listener);
                view.setTag(R.id.markwon_tables_scheduler, (Object)listener);
            }
            TableRowSpan.Invalidator invalidator = new TableRowSpan.Invalidator(){

                @Override
                public void invalidate() {
                    view.setText(view.getText());
                }
            };
            for (Object span : spans) {
                ((TableRowSpan)((Object)span)).invalidator(invalidator);
            }
        }
    }

    static void unschedule(@NonNull TextView view) {
        Object[] spans = TableRowsScheduler.extract(view);
        if (spans != null && spans.length > 0) {
            for (Object span : spans) {
                ((TableRowSpan)((Object)span)).invalidator(null);
            }
        }
    }

    private static Object[] extract(@NonNull TextView view) {
        CharSequence text = view.getText();
        Object[] out = !TextUtils.isEmpty((CharSequence)text) && text instanceof Spanned ? ((Spanned)text).getSpans(0, text.length(), TableRowSpan.class) : null;
        return out;
    }

    private TableRowsScheduler() {
    }
}

