/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.content.Context;
import android.support.annotation.NonNull;
import ru.noties.markwon.AsyncDrawableLoaderNoOp;
import ru.noties.markwon.LinkResolverDef;
import ru.noties.markwon.SpannableFactory;
import ru.noties.markwon.SpannableFactoryDef;
import ru.noties.markwon.SyntaxHighlight;
import ru.noties.markwon.SyntaxHighlightNoOp;
import ru.noties.markwon.UrlProcessor;
import ru.noties.markwon.UrlProcessorNoOp;
import ru.noties.markwon.html.api.MarkwonHtmlParser;
import ru.noties.markwon.html.impl.MarkwonHtmlParserImpl;
import ru.noties.markwon.renderer.ImageSizeResolver;
import ru.noties.markwon.renderer.ImageSizeResolverDef;
import ru.noties.markwon.renderer.html2.MarkwonHtmlRenderer;
import ru.noties.markwon.spans.AsyncDrawable;
import ru.noties.markwon.spans.LinkSpan;
import ru.noties.markwon.spans.SpannableTheme;

public class SpannableConfiguration {
    private final SpannableTheme theme;
    private final AsyncDrawable.Loader asyncDrawableLoader;
    private final SyntaxHighlight syntaxHighlight;
    private final LinkSpan.Resolver linkResolver;
    private final UrlProcessor urlProcessor;
    private final ImageSizeResolver imageSizeResolver;
    private final SpannableFactory factory;
    private final boolean softBreakAddsNewLine;
    private final MarkwonHtmlParser htmlParser;
    private final MarkwonHtmlRenderer htmlRenderer;
    private final boolean htmlAllowNonClosedTags;

    @NonNull
    public static SpannableConfiguration create(@NonNull Context context) {
        return new Builder(context).build();
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context);
    }

    private SpannableConfiguration(@NonNull Builder builder) {
        this.theme = builder.theme;
        this.asyncDrawableLoader = builder.asyncDrawableLoader;
        this.syntaxHighlight = builder.syntaxHighlight;
        this.linkResolver = builder.linkResolver;
        this.urlProcessor = builder.urlProcessor;
        this.imageSizeResolver = builder.imageSizeResolver;
        this.factory = builder.factory;
        this.softBreakAddsNewLine = builder.softBreakAddsNewLine;
        this.htmlParser = builder.htmlParser;
        this.htmlRenderer = builder.htmlRenderer;
        this.htmlAllowNonClosedTags = builder.htmlAllowNonClosedTags;
    }

    @NonNull
    public SpannableTheme theme() {
        return this.theme;
    }

    @NonNull
    public AsyncDrawable.Loader asyncDrawableLoader() {
        return this.asyncDrawableLoader;
    }

    @NonNull
    public SyntaxHighlight syntaxHighlight() {
        return this.syntaxHighlight;
    }

    @NonNull
    public LinkSpan.Resolver linkResolver() {
        return this.linkResolver;
    }

    @NonNull
    public UrlProcessor urlProcessor() {
        return this.urlProcessor;
    }

    @NonNull
    public ImageSizeResolver imageSizeResolver() {
        return this.imageSizeResolver;
    }

    @NonNull
    public SpannableFactory factory() {
        return this.factory;
    }

    public boolean softBreakAddsNewLine() {
        return this.softBreakAddsNewLine;
    }

    @NonNull
    public MarkwonHtmlParser htmlParser() {
        return this.htmlParser;
    }

    @NonNull
    public MarkwonHtmlRenderer htmlRenderer() {
        return this.htmlRenderer;
    }

    public boolean htmlAllowNonClosedTags() {
        return this.htmlAllowNonClosedTags;
    }

    public static class Builder {
        private final Context context;
        private SpannableTheme theme;
        private AsyncDrawable.Loader asyncDrawableLoader;
        private SyntaxHighlight syntaxHighlight;
        private LinkSpan.Resolver linkResolver;
        private UrlProcessor urlProcessor;
        private ImageSizeResolver imageSizeResolver;
        private SpannableFactory factory;
        private boolean softBreakAddsNewLine;
        private MarkwonHtmlParser htmlParser;
        private MarkwonHtmlRenderer htmlRenderer;
        private boolean htmlAllowNonClosedTags;

        Builder(@NonNull Context context) {
            this.context = context;
        }

        @NonNull
        public Builder theme(@NonNull SpannableTheme theme) {
            this.theme = theme;
            return this;
        }

        @NonNull
        public Builder asyncDrawableLoader(@NonNull AsyncDrawable.Loader asyncDrawableLoader) {
            this.asyncDrawableLoader = asyncDrawableLoader;
            return this;
        }

        @NonNull
        public Builder syntaxHighlight(@NonNull SyntaxHighlight syntaxHighlight) {
            this.syntaxHighlight = syntaxHighlight;
            return this;
        }

        @NonNull
        public Builder linkResolver(@NonNull LinkSpan.Resolver linkResolver) {
            this.linkResolver = linkResolver;
            return this;
        }

        @NonNull
        public Builder urlProcessor(@NonNull UrlProcessor urlProcessor) {
            this.urlProcessor = urlProcessor;
            return this;
        }

        @NonNull
        public Builder imageSizeResolver(@NonNull ImageSizeResolver imageSizeResolver) {
            this.imageSizeResolver = imageSizeResolver;
            return this;
        }

        @NonNull
        public Builder factory(@NonNull SpannableFactory factory) {
            this.factory = factory;
            return this;
        }

        @NonNull
        public Builder softBreakAddsNewLine(boolean softBreakAddsNewLine) {
            this.softBreakAddsNewLine = softBreakAddsNewLine;
            return this;
        }

        @NonNull
        public Builder htmlParser(@NonNull MarkwonHtmlParser htmlParser) {
            this.htmlParser = htmlParser;
            return this;
        }

        @NonNull
        public Builder htmlRenderer(@NonNull MarkwonHtmlRenderer htmlRenderer) {
            this.htmlRenderer = htmlRenderer;
            return this;
        }

        @NonNull
        public Builder htmlAllowNonClosedTags(boolean htmlAllowNonClosedTags) {
            this.htmlAllowNonClosedTags = htmlAllowNonClosedTags;
            return this;
        }

        @NonNull
        public SpannableConfiguration build() {
            if (this.theme == null) {
                this.theme = SpannableTheme.create(this.context);
            }
            if (this.asyncDrawableLoader == null) {
                this.asyncDrawableLoader = new AsyncDrawableLoaderNoOp();
            }
            if (this.syntaxHighlight == null) {
                this.syntaxHighlight = new SyntaxHighlightNoOp();
            }
            if (this.linkResolver == null) {
                this.linkResolver = new LinkResolverDef();
            }
            if (this.urlProcessor == null) {
                this.urlProcessor = new UrlProcessorNoOp();
            }
            if (this.imageSizeResolver == null) {
                this.imageSizeResolver = new ImageSizeResolverDef();
            }
            if (this.factory == null) {
                this.factory = SpannableFactoryDef.create();
            }
            if (this.htmlParser == null) {
                try {
                    this.htmlParser = MarkwonHtmlParserImpl.create();
                }
                catch (Throwable t) {
                    this.htmlParser = MarkwonHtmlParser.noOp();
                }
            }
            if (this.htmlRenderer == null) {
                this.htmlRenderer = MarkwonHtmlRenderer.create();
            }
            return new SpannableConfiguration(this);
        }
    }
}

