/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.widget.TextView;
import java.util.Arrays;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import ru.noties.markwon.DrawablesScheduler;
import ru.noties.markwon.SpannableConfiguration;
import ru.noties.markwon.TableRowsScheduler;
import ru.noties.markwon.renderer.SpannableRenderer;
import ru.noties.markwon.tasklist.TaskListExtension;

public abstract class Markwon {
    @NonNull
    public static Parser createParser() {
        return new Parser.Builder().extensions(Arrays.asList(StrikethroughExtension.create(), TablesExtension.create(), TaskListExtension.create())).build();
    }

    public static void setMarkdown(@NonNull TextView view, @NonNull String markdown) {
        Markwon.setMarkdown(view, SpannableConfiguration.create(view.getContext()), markdown);
    }

    public static void setMarkdown(@NonNull TextView view, @NonNull SpannableConfiguration configuration, @NonNull String markdown) {
        Markwon.setText(view, Markwon.markdown(configuration, markdown));
    }

    public static void setText(@NonNull TextView view, CharSequence text) {
        Markwon.setText(view, text, LinkMovementMethod.getInstance());
    }

    public static void setText(@NonNull TextView view, CharSequence text, @Nullable MovementMethod movementMethod) {
        Markwon.unscheduleDrawables(view);
        Markwon.unscheduleTableRows(view);
        view.setMovementMethod(movementMethod);
        view.setText(text);
        Markwon.scheduleDrawables(view);
        Markwon.scheduleTableRows(view);
    }

    @NonNull
    public static CharSequence markdown(@NonNull Context context, @NonNull String markdown) {
        SpannableConfiguration configuration = SpannableConfiguration.create(context);
        return Markwon.markdown(configuration, markdown);
    }

    @NonNull
    public static CharSequence markdown(@NonNull SpannableConfiguration configuration, @NonNull String markdown) {
        Parser parser = Markwon.createParser();
        Node node = parser.parse(markdown);
        SpannableRenderer renderer = new SpannableRenderer();
        return renderer.render(configuration, node);
    }

    public static void scheduleDrawables(@NonNull TextView view) {
        DrawablesScheduler.schedule(view);
    }

    public static void unscheduleDrawables(@NonNull TextView view) {
        DrawablesScheduler.unschedule(view);
    }

    public static void scheduleTableRows(@NonNull TextView view) {
        TableRowsScheduler.schedule(view);
    }

    public static void unscheduleTableRows(@NonNull TextView view) {
        TableRowsScheduler.unschedule(view);
    }

    private Markwon() {
    }
}

