/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.html.impl;

import android.support.annotation.NonNull;
import ru.noties.markwon.html.impl.AppendableUtils;

abstract class TrimmingAppender {
    TrimmingAppender() {
    }

    abstract <T extends Appendable & CharSequence> void append(@NonNull T var1, @NonNull String var2);

    @NonNull
    static TrimmingAppender create() {
        return new Impl();
    }

    static class Impl
    extends TrimmingAppender {
        Impl() {
        }

        @Override
        <T extends Appendable & CharSequence> void append(@NonNull T output, @NonNull String data) {
            int startLength = ((CharSequence)output).length();
            boolean previousIsWhiteSpace = false;
            int length = data.length();
            for (int i = 0; i < length; ++i) {
                int outputLength;
                char c = data.charAt(i);
                if (Character.isWhitespace(c)) {
                    previousIsWhiteSpace = true;
                    continue;
                }
                if (previousIsWhiteSpace && (outputLength = ((CharSequence)output).length()) > 0 && !Character.isWhitespace(((CharSequence)output).charAt(outputLength - 1))) {
                    AppendableUtils.appendQuietly(output, ' ');
                }
                previousIsWhiteSpace = false;
                AppendableUtils.appendQuietly(output, c);
            }
            if (previousIsWhiteSpace && startLength < ((CharSequence)output).length()) {
                AppendableUtils.appendQuietly(output, ' ');
            }
        }
    }
}

