/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.html.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.noties.markwon.html.api.HtmlTag;

abstract class HtmlTagImpl
implements HtmlTag {
    final String name;
    final int start;
    final Map<String, String> attributes;
    int end = -1;

    protected HtmlTagImpl(@NonNull String name, int start, @NonNull Map<String, String> attributes) {
        this.name = name;
        this.start = start;
        this.attributes = attributes;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    @NonNull
    public Map<String, String> attributes() {
        return this.attributes;
    }

    public boolean isClosed() {
        return this.end > -1;
    }

    abstract void closeAt(int var1);

    static class BlockImpl
    extends HtmlTagImpl
    implements HtmlTag.Block {
        final BlockImpl parent;
        List<BlockImpl> children;

        @NonNull
        static BlockImpl root() {
            return new BlockImpl("", 0, Collections.emptyMap(), null);
        }

        @NonNull
        static BlockImpl create(@NonNull String name, int start, @NonNull Map<String, String> attributes, @Nullable BlockImpl parent) {
            return new BlockImpl(name, start, attributes, parent);
        }

        BlockImpl(@NonNull String name, int start, @NonNull Map<String, String> attributes, @Nullable BlockImpl parent) {
            super(name, start, attributes);
            this.parent = parent;
        }

        @Override
        void closeAt(int end) {
            if (!this.isClosed()) {
                this.end = end;
                if (this.children != null) {
                    for (BlockImpl child : this.children) {
                        child.closeAt(end);
                    }
                }
            }
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        @Nullable
        public HtmlTag.Block parent() {
            return this.parent;
        }

        @NonNull
        public List<HtmlTag.Block> children() {
            List<Object> list = this.children == null ? Collections.emptyList() : Collections.unmodifiableList(this.children);
            return list;
        }

        @Override
        @NonNull
        public Map<String, String> attributes() {
            return this.attributes;
        }

        public boolean isInline() {
            return false;
        }

        public boolean isBlock() {
            return true;
        }

        @NonNull
        public HtmlTag.Inline getAsInline() {
            throw new ClassCastException("Cannot cast Block instance to Inline");
        }

        @NonNull
        public HtmlTag.Block getAsBlock() {
            return this;
        }

        public String toString() {
            return "BlockImpl{name='" + this.name + '\'' + ", start=" + this.start + ", end=" + this.end + ", attributes=" + this.attributes + ", parent=" + (this.parent != null ? this.parent.name : null) + ", children=" + this.children + '}';
        }
    }

    static class InlineImpl
    extends HtmlTagImpl
    implements HtmlTag.Inline {
        InlineImpl(@NonNull String name, int start, @NonNull Map<String, String> attributes) {
            super(name, start, attributes);
        }

        @Override
        void closeAt(int end) {
            if (!this.isClosed()) {
                this.end = end;
            }
        }

        public String toString() {
            return "InlineImpl{name='" + this.name + '\'' + ", start=" + this.start + ", end=" + this.end + ", attributes=" + this.attributes + '}';
        }

        public boolean isInline() {
            return true;
        }

        public boolean isBlock() {
            return false;
        }

        @NonNull
        public HtmlTag.Inline getAsInline() {
            return this;
        }

        @NonNull
        public HtmlTag.Block getAsBlock() {
            throw new ClassCastException("Cannot cast Inline instance to Block");
        }
    }
}

