/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.util;

import com.flowpowered.nbt.ByteArrayTag;
import com.flowpowered.nbt.ByteTag;
import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.CompoundTag;
import com.flowpowered.nbt.DoubleTag;
import com.flowpowered.nbt.FloatTag;
import com.flowpowered.nbt.IntArrayTag;
import com.flowpowered.nbt.IntTag;
import com.flowpowered.nbt.ListTag;
import com.flowpowered.nbt.LongTag;
import com.flowpowered.nbt.ShortArrayTag;
import com.flowpowered.nbt.ShortTag;
import com.flowpowered.nbt.StringTag;
import com.flowpowered.nbt.Tag;
import com.flowpowered.nbt.TagType;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class NbtUtil {
    public static byte orDefaultByte(@NotNull CompoundMap tags, @NotNull String tagName, byte defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_BYTE ? defaultValue : ((ByteTag)tag).getValue();
    }

    public static byte orDefaultByte(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<@NotNull Byte> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_BYTE ? defaultValueSupplier.get() : ((ByteTag)tag).getValue();
    }

    public static short orDefaultShort(@NotNull CompoundMap tags, @NotNull String tagName, short defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_SHORT ? defaultValue : ((ShortTag)tag).getValue();
    }

    public static short orDefaultShort(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<@NotNull Short> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_SHORT ? defaultValueSupplier.get() : ((ShortTag)tag).getValue();
    }

    public static int orDefaultInt(@NotNull CompoundMap tags, @NotNull String tagName, int defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_INT ? defaultValue : ((IntTag)tag).getValue();
    }

    public static int orDefaultInt(@NotNull CompoundMap tags, @NotNull String tagName, @NotNull IntSupplier defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_INT ? defaultValueSupplier.getAsInt() : ((IntTag)tag).getValue().intValue();
    }

    public static long orDefaultLong(@NotNull CompoundMap tags, @NotNull String tagName, long defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_LONG ? defaultValue : ((LongTag)tag).getValue();
    }

    public static long orDefaultLong(@NotNull CompoundMap tags, @NotNull String tagName, @NotNull LongSupplier defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_LONG ? defaultValueSupplier.getAsLong() : ((LongTag)tag).getValue().longValue();
    }

    public static float orDefaultFloat(@NotNull CompoundMap tags, @NotNull String tagName, float defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_FLOAT ? defaultValue : ((FloatTag)tag).getValue().floatValue();
    }

    public static float orDefaultFloat(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<@NotNull Float> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return (tag == null || tag.getType() != TagType.TAG_FLOAT ? defaultValueSupplier.get() : ((FloatTag)tag).getValue()).floatValue();
    }

    public static double orDefaultDouble(@NotNull CompoundMap tags, @NotNull String tagName, double defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_DOUBLE ? defaultValue : ((DoubleTag)tag).getValue();
    }

    public static double orDefaultDouble(@NotNull CompoundMap tags, @NotNull String tagName, @NotNull DoubleSupplier defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_DOUBLE ? defaultValueSupplier.getAsDouble() : ((DoubleTag)tag).getValue().doubleValue();
    }

    public static byte[] orDefaultByteArray(@NotNull CompoundMap tags, @NotNull String tagName, byte[] defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_BYTE_ARRAY ? defaultValue : ((ByteArrayTag)tag).getValue();
    }

    public static byte[] orDefaultByteArray(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<byte[]> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_BYTE_ARRAY ? defaultValueSupplier.get() : ((ByteArrayTag)tag).getValue();
    }

    public static String orDefaultString(@NotNull CompoundMap tags, @NotNull String tagName, String defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_STRING ? defaultValue : ((StringTag)tag).getValue();
    }

    public static String orDefaultString(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<String> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_STRING ? defaultValueSupplier.get() : ((StringTag)tag).getValue();
    }

    public static <T extends Tag<?>> List<T> orDefaultList(@NotNull CompoundMap tags, @NotNull String tagName, List<T> defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_LIST ? defaultValue : ((ListTag)tag).getValue();
    }

    public static <T extends Tag<?>> List<T> orDefaultList(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<List<T>> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_LIST ? defaultValueSupplier.get() : ((ListTag)tag).getValue();
    }

    public static CompoundMap orDefaultCompound(@NotNull CompoundMap tags, @NotNull String tagName, CompoundMap defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_COMPOUND ? defaultValue : ((CompoundTag)tag).getValue();
    }

    public static CompoundMap orDefaultCompound(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<CompoundMap> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_COMPOUND ? defaultValueSupplier.get() : ((CompoundTag)tag).getValue();
    }

    public static short[] orDefaultShortArray(@NotNull CompoundMap tags, @NotNull String tagName, short[] defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_SHORT_ARRAY ? defaultValue : ((ShortArrayTag)tag).getValue();
    }

    public static short[] orDefaultShortArray(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<short[]> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_SHORT_ARRAY ? defaultValueSupplier.get() : ((ShortArrayTag)tag).getValue();
    }

    public static int[] orDefaultIntArray(@NotNull CompoundMap tags, @NotNull String tagName, int[] defaultValue) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_INT_ARRAY ? defaultValue : ((IntArrayTag)tag).getValue();
    }

    public static int[] orDefaultIntArray(@NotNull CompoundMap tags, @NotNull String tagName, Supplier<int[]> defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        return tag == null || tag.getType() != TagType.TAG_INT_ARRAY ? defaultValueSupplier.get() : ((IntArrayTag)tag).getValue();
    }

    public static int readInt(@NotNull CompoundMap tags, @NotNull String tagName, int defaultValue) {
        Tag tag = tags.get((Object)tagName);
        if (tag == null) {
            return defaultValue;
        }
        switch (tag.getType()) {
            case TAG_BYTE: {
                return ((ByteTag)tag).getValue().byteValue();
            }
            case TAG_SHORT: {
                return ((ShortTag)tag).getValue().shortValue();
            }
            case TAG_INT: {
                return ((IntTag)tag).getValue();
            }
            case TAG_LONG: {
                return ((LongTag)tag).getValue().intValue();
            }
        }
        return defaultValue;
    }

    public static int readInt(@NotNull CompoundMap tags, @NotNull String tagName, IntSupplier defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        if (tag == null) {
            return defaultValueSupplier.getAsInt();
        }
        switch (tag.getType()) {
            case TAG_BYTE: {
                return ((ByteTag)tag).getValue().byteValue();
            }
            case TAG_SHORT: {
                return ((ShortTag)tag).getValue().shortValue();
            }
            case TAG_INT: {
                return ((IntTag)tag).getValue();
            }
            case TAG_LONG: {
                return ((LongTag)tag).getValue().intValue();
            }
        }
        return defaultValueSupplier.getAsInt();
    }

    public static long readLong(@NotNull CompoundMap tags, @NotNull String tagName, long defaultValue) {
        Tag tag = tags.get((Object)tagName);
        if (tag == null) {
            return defaultValue;
        }
        switch (tag.getType()) {
            case TAG_BYTE: {
                return ((ByteTag)tag).getValue().byteValue();
            }
            case TAG_SHORT: {
                return ((ShortTag)tag).getValue().shortValue();
            }
            case TAG_INT: {
                return ((IntTag)tag).getValue().intValue();
            }
            case TAG_LONG: {
                return ((LongTag)tag).getValue();
            }
        }
        return defaultValue;
    }

    public static long readLong(@NotNull CompoundMap tags, @NotNull String tagName, LongSupplier defaultValueSupplier) {
        Tag tag = tags.get((Object)tagName);
        if (tag == null) {
            return defaultValueSupplier.getAsLong();
        }
        switch (tag.getType()) {
            case TAG_BYTE: {
                return ((ByteTag)tag).getValue().byteValue();
            }
            case TAG_SHORT: {
                return ((ShortTag)tag).getValue().shortValue();
            }
            case TAG_INT: {
                return ((IntTag)tag).getValue().intValue();
            }
            case TAG_LONG: {
                return ((LongTag)tag).getValue();
            }
        }
        return defaultValueSupplier.getAsLong();
    }

    private NbtUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

