/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.util;

import com.flowpowered.nbt.ByteArrayTag;
import com.flowpowered.nbt.ByteTag;
import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.CompoundTag;
import com.flowpowered.nbt.DoubleTag;
import com.flowpowered.nbt.EndTag;
import com.flowpowered.nbt.FloatTag;
import com.flowpowered.nbt.IntArrayTag;
import com.flowpowered.nbt.IntTag;
import com.flowpowered.nbt.ListTag;
import com.flowpowered.nbt.LongTag;
import com.flowpowered.nbt.ShortTag;
import com.flowpowered.nbt.StringTag;
import com.flowpowered.nbt.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import ru.divinecraft.customstuff.api.nbt.NBTCompound;
import ru.divinecraft.customstuff.api.nbt.NBTCompoundList;
import ru.divinecraft.customstuff.api.nbt.NBTList;
import ru.divinecraft.customstuff.api.nbt.NBTType;

@Deprecated
public final class NbtConversionUtil {
    @NotNull
    public static CompoundTag toCompoundTag(@NotNull NBTCompound nbtCompound) {
        return new CompoundTag(nbtCompound.getName(), NbtConversionUtil.toCompoundMap(nbtCompound));
    }

    @NotNull
    public static CompoundMap toCompoundMap(@NotNull NBTCompound compound) {
        Set<String> keys = compound.getKeys();
        if (keys.isEmpty()) {
            return new CompoundMap();
        }
        CompoundMap compoundMap = new CompoundMap();
        block26: for (String key : keys) {
            switch (compound.getType(key)) {
                case NBTTagEnd: {
                    compoundMap.put(key, (Tag)new EndTag());
                    continue block26;
                }
                case NBTTagByte: {
                    compoundMap.put((Tag)new ByteTag(key, compound.getByte(key).byteValue()));
                    continue block26;
                }
                case NBTTagShort: {
                    compoundMap.put((Tag)new ShortTag(key, compound.getShort(key).shortValue()));
                    continue block26;
                }
                case NBTTagInt: {
                    compoundMap.put((Tag)new IntTag(key, compound.getInteger(key).intValue()));
                    continue block26;
                }
                case NBTTagLong: {
                    compoundMap.put((Tag)new LongTag(key, compound.getLong(key).longValue()));
                    continue block26;
                }
                case NBTTagFloat: {
                    compoundMap.put((Tag)new FloatTag(key, compound.getFloat(key).floatValue()));
                    continue block26;
                }
                case NBTTagDouble: {
                    compoundMap.put((Tag)new DoubleTag(key, compound.getDouble(key).doubleValue()));
                    continue block26;
                }
                case NBTTagByteArray: {
                    compoundMap.put((Tag)new ByteArrayTag(key, compound.getByteArray(key)));
                    continue block26;
                }
                case NBTTagIntArray: {
                    compoundMap.put((Tag)new IntArrayTag(key, compound.getIntArray(key)));
                    continue block26;
                }
                case NBTTagString: {
                    compoundMap.put((Tag)new StringTag(key, compound.getString(key)));
                    continue block26;
                }
                case NBTTagList: {
                    ListTag listTag;
                    try {
                        listTag = new ListTag(key, Tag.class, compound.getIntegerList(key).stream().map(value -> new IntTag("", value.intValue())).collect(Collectors.toList()));
                    }
                    catch (Throwable throwable) {
                        try {
                            listTag = new ListTag(key, Tag.class, compound.getLongList(key).stream().map(value -> new LongTag("", value.longValue())).collect(Collectors.toList()));
                        }
                        catch (Throwable throwable2) {
                            try {
                                listTag = new ListTag(key, Tag.class, compound.getFloatList(key).stream().map(value -> new FloatTag("", value.floatValue())).collect(Collectors.toList()));
                            }
                            catch (Throwable throwable3) {
                                try {
                                    listTag = new ListTag(key, Tag.class, compound.getDoubleList(key).stream().map(value -> new DoubleTag("", value.doubleValue())).collect(Collectors.toList()));
                                }
                                catch (Throwable throwable4) {
                                    try {
                                        listTag = new ListTag(key, Tag.class, compound.getStringList(key).stream().map(value -> new StringTag("", value)).collect(Collectors.toList()));
                                    }
                                    catch (Throwable throwable5) {
                                        try {
                                            listTag = new ListTag(key, Tag.class, compound.getCompoundList(key).stream().map(NbtConversionUtil::toCompoundTag).collect(Collectors.toList()));
                                        }
                                        catch (Throwable throwable6) {
                                            throw new Error("Unknown NBT list type");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    compoundMap.put((Tag)listTag);
                    continue block26;
                }
                case NBTTagCompound: {
                    compoundMap.put((Tag)NbtConversionUtil.toCompoundTag(compound.getCompound(key)));
                    continue block26;
                }
            }
            throw new IllegalStateException("Unknown tag type: " + (Object)((Object)compound.getType(key)));
        }
        return compoundMap;
    }

    public static void addTagsToNbtCompound(@NotNull NBTCompound compound, @NotNull CompoundMap tags) {
        block15: for (Map.Entry entry : tags.entrySet()) {
            switch (((Tag)entry.getValue()).getType()) {
                case TAG_END: {
                    throw new RuntimeException("Raw END tag");
                }
                case TAG_BYTE: {
                    compound.setByte((String)entry.getKey(), ((ByteTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_SHORT: {
                    compound.setShort((String)entry.getKey(), ((ShortTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_INT: {
                    compound.setInteger((String)entry.getKey(), ((IntTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_LONG: {
                    compound.setLong((String)entry.getKey(), ((LongTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_FLOAT: {
                    compound.setFloat((String)entry.getKey(), ((FloatTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_DOUBLE: {
                    compound.setDouble((String)entry.getKey(), ((DoubleTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_BYTE_ARRAY: {
                    compound.setByteArray((String)entry.getKey(), ((ByteArrayTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_STRING: {
                    compound.setString((String)entry.getKey(), ((StringTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_LIST: {
                    NBTCompoundList list;
                    ListTag listTag = (ListTag)entry.getValue();
                    Class elementType = listTag.getElementType();
                    if (elementType == IntTag.class) {
                        list = compound.getIntegerList((String)entry.getKey());
                        for (IntTag tag : listTag.getValue()) {
                            ((NBTList)list).add((Integer)tag.getValue());
                        }
                        continue block15;
                    }
                    if (elementType == LongTag.class) {
                        list = compound.getLongList((String)entry.getKey());
                        for (IntTag tag : listTag.getValue()) {
                            ((NBTList)list).add((Integer)((Object)tag.getValue()));
                        }
                        continue block15;
                    }
                    if (elementType == FloatTag.class) {
                        list = compound.getFloatList((String)entry.getKey());
                        for (IntTag tag : listTag.getValue()) {
                            ((NBTList)list).add(tag.getValue());
                        }
                        continue block15;
                    }
                    if (elementType == DoubleTag.class) {
                        list = compound.getDoubleList((String)entry.getKey());
                        for (IntTag tag : listTag.getValue()) {
                            ((NBTList)list).add(tag.getValue());
                        }
                        continue block15;
                    }
                    if (elementType == StringTag.class) {
                        list = compound.getStringList((String)entry.getKey());
                        for (IntTag tag : listTag.getValue()) {
                            ((NBTList)list).add(tag.getValue());
                        }
                        continue block15;
                    }
                    if (elementType == CompoundTag.class) {
                        list = compound.getCompoundList((String)entry.getKey());
                        for (IntTag tag : listTag.getValue()) {
                            NbtConversionUtil.addTagsToNbtCompound(list.addCompound(), tag.getValue());
                        }
                        continue block15;
                    }
                    throw new RuntimeException("Unsupported List type");
                }
                case TAG_COMPOUND: {
                    NbtConversionUtil.addTagsToNbtCompound(compound.addCompound((String)entry.getKey()), ((CompoundTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_INT_ARRAY: {
                    compound.setIntArray((String)entry.getKey(), ((IntArrayTag)entry.getValue()).getValue());
                    break;
                }
                case TAG_SHORT_ARRAY: {
                    throw new RuntimeException("short[]s are not supported");
                }
            }
        }
    }

    public static Class<?> getFlowWrappedType(@NotNull NBTType type) {
        switch (type) {
            case NBTTagEnd: {
                return Object.class;
            }
            case NBTTagByte: {
                return Byte.class;
            }
            case NBTTagShort: {
                return Short.class;
            }
            case NBTTagInt: {
                return Integer.class;
            }
            case NBTTagLong: {
                return Long.class;
            }
            case NBTTagFloat: {
                return Float.class;
            }
            case NBTTagDouble: {
                return Double.class;
            }
            case NBTTagByteArray: {
                return byte[].class;
            }
            case NBTTagIntArray: {
                return int[].class;
            }
            case NBTTagString: {
                return String.class;
            }
            case NBTTagList: {
                return List.class;
            }
            case NBTTagCompound: {
                return CompoundMap.class;
            }
        }
        throw new IllegalStateException("Unknown tag type: " + (Object)((Object)type));
    }

    private NbtConversionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

