/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.service;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import ru.divinecraft.customstuff.api.service.CustomStuffService;
import ru.progrm_jarvis.javacommons.service.AbstractConcurrentService;

public abstract class AbstractCustomStuffService
extends AbstractConcurrentService
implements CustomStuffService {
    @NonNull
    protected final AtomicBoolean loaded = new AtomicBoolean();

    protected AbstractCustomStuffService(Lock lifecycleLock) {
        super(lifecycleLock);
    }

    protected abstract void onLoad();

    protected abstract void onUnload();

    @Override
    public void load() {
        Lock lock = this.lifecycleLock;
        lock.lock();
        try {
            if (this.loaded.compareAndSet(false, true)) {
                this.onLoad();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void unload() {
        Lock lock = this.lifecycleLock;
        lock.lock();
        try {
            if (this.loaded.compareAndSet(true, false)) {
                this.onUnload();
            }
        }
        finally {
            lock.unlock();
        }
    }
}

