/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.chunk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.WillNotClose;
import lombok.NonNull;
import org.bukkit.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.divinecraft.customstuff.api.block.manager.CustomBlockManager;
import ru.divinecraft.customstuff.api.chunk.CustomBlockChunk;
import ru.divinecraft.customstuff.api.chunk.CustomBlockChunkLoader;
import ru.progrm_jarvis.javacommons.io.wrapper.IOWrappers;

public abstract class AbstractCustomBlockChunkLoader
implements CustomBlockChunkLoader {
    @NonNull
    protected final CustomBlockChunk.Reader chunkReader;

    @WillNotClose
    @Nullable
    protected abstract InputStream openInputStream(@NotNull Chunk var1) throws IOException;

    @WillNotClose
    @NotNull
    protected abstract OutputStream openOutputStream(@NotNull Chunk var1) throws IOException;

    protected abstract void deleteData(@NotNull Chunk var1) throws IOException;

    @Override
    @NotNull
    public CustomBlockChunk load(@NotNull Chunk chunk, @NotNull CustomBlockManager blockManager) throws IOException {
        try (InputStream chunkInputStream = this.openInputStream(chunk);){
            CustomBlockChunk customBlockChunk = chunkInputStream == null ? this.chunkReader.createNew(blockManager, chunk) : this.chunkReader.read(blockManager, chunk, IOWrappers.nonAutoCloseable((InputStream)chunkInputStream));
            return customBlockChunk;
        }
    }

    @Override
    public void unload(@NotNull CustomBlockChunk chunk) throws IOException {
        if (chunk.isDirty() || chunk.hasDirtyBlocks()) {
            if (chunk.isEmpty()) {
                this.deleteData(chunk.getChunk());
            } else {
                try (OutputStream chunkOutputStream = this.openOutputStream(chunk.getChunk());){
                    chunk.writeAndUnload(IOWrappers.nonAutoCloseable((OutputStream)chunkOutputStream));
                }
            }
            chunk.notDirty();
        }
    }

    protected AbstractCustomBlockChunkLoader(@NonNull CustomBlockChunk.Reader chunkReader) {
        if (chunkReader == null) {
            throw new NullPointerException("chunkReader is marked non-null but is null");
        }
        this.chunkReader = chunkReader;
    }
}

