/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.georss.GMLModuleImpl;
import com.sun.syndication.feed.module.georss.GeoRSSModule;
import com.sun.syndication.feed.module.georss.GeoRSSUtils;
import com.sun.syndication.feed.module.georss.geometries.Envelope;
import com.sun.syndication.feed.module.georss.geometries.LineString;
import com.sun.syndication.feed.module.georss.geometries.LinearRing;
import com.sun.syndication.feed.module.georss.geometries.Point;
import com.sun.syndication.feed.module.georss.geometries.Polygon;
import com.sun.syndication.feed.module.georss.geometries.Position;
import com.sun.syndication.feed.module.georss.geometries.PositionList;
import com.sun.syndication.io.ModuleParser;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class GMLParser
implements ModuleParser {
    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    public Module parse(Element element) {
        Module geoRssModule = GMLParser.parseGML(element);
        return geoRssModule;
    }

    private static PositionList parsePosList(Element element) {
        String coordinates = element.getText();
        String[] coord = GeoRSSUtils.trimWhitespace(coordinates).split(" ");
        PositionList posList = new PositionList();
        for (int i = 0; i < coord.length; i += 2) {
            posList.add(Double.parseDouble(coord[i]), Double.parseDouble(coord[i + 1]));
        }
        return posList;
    }

    static Module parseGML(Element element) {
        GMLModuleImpl geoRSSModule = null;
        Element pointElement = element.getChild("Point", GeoRSSModule.GML_NS);
        Element lineStringElement = element.getChild("LineString", GeoRSSModule.GML_NS);
        Element polygonElement = element.getChild("Polygon", GeoRSSModule.GML_NS);
        Element envelopeElement = element.getChild("Envelope", GeoRSSModule.GML_NS);
        if (pointElement != null) {
            Element posElement = pointElement.getChild("pos", GeoRSSModule.GML_NS);
            if (posElement != null) {
                geoRSSModule = new GMLModuleImpl();
                String coordinates = posElement.getText();
                String[] coord = GeoRSSUtils.trimWhitespace(coordinates).split(" ");
                Position pos = new Position(Double.parseDouble(coord[0]), Double.parseDouble(coord[1]));
                geoRSSModule.setGeometry(new Point(pos));
            }
        } else if (lineStringElement != null) {
            Element posListElement = lineStringElement.getChild("posList", GeoRSSModule.GML_NS);
            if (posListElement != null) {
                geoRSSModule = new GMLModuleImpl();
                geoRSSModule.setGeometry(new LineString(GMLParser.parsePosList(posListElement)));
            }
        } else if (polygonElement != null) {
            Element posListElement;
            Element linearRingElement;
            Polygon poly = null;
            Element exteriorElement = polygonElement.getChild("exterior", GeoRSSModule.GML_NS);
            if (exteriorElement != null && (linearRingElement = exteriorElement.getChild("LinearRing", GeoRSSModule.GML_NS)) != null && (posListElement = linearRingElement.getChild("posList", GeoRSSModule.GML_NS)) != null) {
                if (poly == null) {
                    poly = new Polygon();
                }
                poly.setExterior(new LinearRing(GMLParser.parsePosList(posListElement)));
            }
            List interiorElementList = polygonElement.getChildren("interior", GeoRSSModule.GML_NS);
            Iterator it = interiorElementList.iterator();
            while (it.hasNext()) {
                Element posListElement2;
                Element linearRingElement2;
                Element interiorElement = (Element)it.next();
                if (interiorElement == null || (linearRingElement2 = interiorElement.getChild("LinearRing", GeoRSSModule.GML_NS)) == null || (posListElement2 = linearRingElement2.getChild("posList", GeoRSSModule.GML_NS)) == null) continue;
                if (poly == null) {
                    poly = new Polygon();
                }
                poly.getInterior().add(new LinearRing(GMLParser.parsePosList(posListElement2)));
            }
            if (poly != null) {
                geoRSSModule = new GMLModuleImpl();
                geoRSSModule.setGeometry(poly);
            }
        } else if (envelopeElement != null) {
            Element lowerElement = envelopeElement.getChild("lowerCorner", GeoRSSModule.GML_NS);
            Element upperElement = envelopeElement.getChild("upperCorner", GeoRSSModule.GML_NS);
            if (lowerElement != null && upperElement != null) {
                geoRSSModule = new GMLModuleImpl();
                String lowerCoordinates = lowerElement.getText();
                String[] lowerCoord = GeoRSSUtils.trimWhitespace(lowerCoordinates).split(" ");
                String upperCoordinates = upperElement.getText();
                String[] upperCoord = GeoRSSUtils.trimWhitespace(upperCoordinates).split(" ");
                Envelope envelope = new Envelope(Double.parseDouble(lowerCoord[0]), Double.parseDouble(lowerCoord[1]), Double.parseDouble(upperCoord[0]), Double.parseDouble(upperCoord[1]));
                geoRSSModule.setGeometry(envelope);
            }
        }
        return geoRSSModule;
    }
}

