/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.ircbot.botlet;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.codehaus.plexus.ircbot.IrcBot;
import org.codehaus.plexus.ircbot.botlet.AbstractBotlet;

public class LoggerBotlet
extends AbstractBotlet {
    private boolean logging;
    private PrintWriter log;

    public void handleCommand(IrcBot bot, String channel, String user, String request) {
        if (request.startsWith("start")) {
            this.start(bot, channel);
        } else if (request.startsWith("stop")) {
            this.stop(bot, channel);
        } else if (request.startsWith("status")) {
            this.status(bot, channel);
        }
    }

    public void handleText(IrcBot bot, String channel, String user, String text) {
        if (this.logging) {
            this.log.println("<" + user + "> " + text);
            this.log.flush();
        }
    }

    protected void status(IrcBot bot, String channel) {
        this.message(bot, channel, "I'm not giving you anything until you give me some spanish peanuts.");
    }

    protected void stop(IrcBot bot, String channel) {
        this.message(bot, channel, "Fine. Up yours. I won't record you anymore.");
        this.log.close();
        this.log = null;
        this.logging = false;
    }

    protected void start(IrcBot bot, String channel) {
        this.message(bot, channel, "I will start logging your fascinating conversation, I promise not to tell ACO.");
        this.logging = true;
        if (this.log == null) {
            try {
                this.log = new PrintWriter(new FileWriter("log.txt", true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

