/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.AttributeEncryptor;
import com.amazonaws.services.dynamodbv2.datamodeling.AttributeTransformer;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.DirectKmsMaterialProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;

public class DynamoDbMapperFactory {
    public static DynamoDBMapper createEncryptionDynamoDbMapper(String tableName, String keyId) {
        AWSKMS kms = (AWSKMS)AWSKMSClientBuilder.standard().build();
        DirectKmsMaterialProvider encryptionMaterialsProvider = new DirectKmsMaterialProvider(kms, keyId);
        return DynamoDbMapperFactory.createDynamoDbMapper(tableName, (AttributeTransformer)new AttributeEncryptor((EncryptionMaterialsProvider)encryptionMaterialsProvider));
    }

    public static DynamoDBMapper createDynamoDbMapper(String tableName) {
        return DynamoDbMapperFactory.createDynamoDbMapper(tableName, null);
    }

    private static DynamoDBMapper createDynamoDbMapper(String tableName, AttributeTransformer attributeTransformer) {
        AmazonDynamoDB dynamoDb = (AmazonDynamoDB)AmazonDynamoDBClientBuilder.standard().build();
        DynamoDBMapperConfig mapperConfig = DynamoDBMapperConfig.builder().withTableNameOverride(new DynamoDBMapperConfig.TableNameOverride(tableName)).withSaveBehavior(DynamoDBMapperConfig.SaveBehavior.PUT).build();
        return new DynamoDBMapper(dynamoDb, mapperConfig, attributeTransformer);
    }
}

