/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pl.wavesoftware.eid.exceptions.Eid;
import pl.wavesoftware.eid.exceptions.EidIllegalArgumentException;
import pl.wavesoftware.eid.exceptions.EidIllegalStateException;
import pl.wavesoftware.eid.exceptions.EidIndexOutOfBoundsException;
import pl.wavesoftware.eid.exceptions.EidNullPointerException;
import pl.wavesoftware.eid.exceptions.EidRuntimeException;

public final class EidPreconditions {
    protected EidPreconditions() {
        throw new EidRuntimeException("20150718:083450", "This should not be accessed");
    }

    public static void checkArgument(boolean expression, String eid) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid));
        }
    }

    public static void checkArgument(boolean expression, String eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
    }

    public static void checkArgument(boolean expression, Eid eid) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid));
        }
    }

    public static void checkArgument(boolean expression, Eid eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
    }

    public static void checkState(boolean expression, String eid) {
        if (!expression) {
            throw new EidIllegalStateException(EidPreconditions.ensureEid(eid));
        }
    }

    public static void checkState(boolean expression, String eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalStateException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
    }

    public static void checkState(Boolean expression, Eid eid) {
        if (!expression.booleanValue()) {
            throw new EidIllegalStateException(EidPreconditions.ensureEid(eid));
        }
    }

    public static void checkState(boolean expression, Eid eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalStateException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
    }

    public static <T> T checkNotNull(@Nullable T reference, String eid) {
        if (reference == null) {
            throw new EidNullPointerException(EidPreconditions.ensureEid(eid));
        }
        return reference;
    }

    public static <T> T checkNotNull(@Nullable T reference, String eid, String messageFormat, Object ... parameters) {
        if (reference == null) {
            throw new EidNullPointerException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
        return reference;
    }

    public static <T> T checkNotNull(@Nullable T reference, Eid eid) {
        if (reference == null) {
            throw new EidNullPointerException(EidPreconditions.ensureEid(eid));
        }
        return reference;
    }

    @Nonnull
    public static <T> T checkNotNull(@Nullable T reference, Eid eid, String messageFormat, Object ... parameters) {
        if (reference == null) {
            throw new EidNullPointerException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
        return reference;
    }

    public static int checkElementIndex(int index, int size, String eid) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid));
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidPreconditions.ensureEid(eid));
        }
        return index;
    }

    public static int checkElementIndex(int index, int size, String eid, String messageFormat, Object ... parameters) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
        return index;
    }

    public static int checkElementIndex(int index, int size, Eid eid) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid));
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidPreconditions.ensureEid(eid));
        }
        return index;
    }

    public static int checkElementIndex(int index, int size, Eid eid, String messageFormat, Object ... parameters) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidPreconditions.ensureEid(eid), messageFormat, parameters);
        }
        return index;
    }

    private static boolean isIndexAndSizeIllegal(int index, int size) {
        return index < 0 || index > size;
    }

    private static boolean isSizeIllegal(int size) {
        return size < 0;
    }

    public static <R> R tryToExecute(UnsafeSupplier<R> supplier, String eid) {
        try {
            return supplier.get();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidPreconditions.ensureEid(eid), (Throwable)throwable);
        }
    }

    public static void tryToExecute(UnsafeProcedure procedure, String eid) {
        try {
            procedure.execute();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidPreconditions.ensureEid(eid), (Throwable)throwable);
        }
    }

    public static <R> R tryToExecute(UnsafeSupplier<R> supplier, Eid eid) {
        try {
            return supplier.get();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidPreconditions.ensureEid(eid), (Throwable)throwable);
        }
    }

    public static void tryToExecute(UnsafeProcedure procedure, Eid eid) {
        try {
            procedure.execute();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidPreconditions.ensureEid(eid), (Throwable)throwable);
        }
    }

    private static Eid ensureEid(@Nullable Eid eid) {
        if (eid == null) {
            return new Eid("20160329:132823", "EID-NULL");
        }
        return eid;
    }

    private static Eid ensureEid(@Nullable String eid) {
        if (eid == null) {
            return new Eid("20160329:133052", "EID-NULL");
        }
        return new Eid(eid);
    }

    public static interface UnsafeProcedure {
        public void execute() throws Exception;
    }

    public static interface UnsafeSupplier<T> {
        public T get() throws Exception;
    }
}

