/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.exceptions;

import java.util.Locale;
import javax.annotation.Nullable;
import pl.wavesoftware.eid.exceptions.Eid;
import pl.wavesoftware.eid.exceptions.EidContainer;

public class EidRuntimeException
extends RuntimeException
implements EidContainer {
    private static final long serialVersionUID = -9876432123423587L;
    private final Eid eid;

    public EidRuntimeException(String eid, String ref) {
        this(new Eid(eid, ref));
    }

    public EidRuntimeException(String eid, Throwable cause) {
        this(new Eid(eid), cause);
    }

    public EidRuntimeException(String eid, String ref, Throwable cause) {
        this(new Eid(eid, ref), cause);
    }

    public EidRuntimeException(Eid id) {
        super(id.toString());
        this.eid = id;
    }

    public EidRuntimeException(Eid id, Throwable cause) {
        super(String.format(Locale.ENGLISH, Eid.getMessageFormat(), id.toString(), EidRuntimeException.message(cause)), cause);
        this.eid = id;
    }

    public EidRuntimeException(Eid id, String messageFormat, Object ... parameters) {
        super(String.format(Locale.ENGLISH, Eid.getMessageFormat(), id.toString(), String.format(Locale.ENGLISH, messageFormat, parameters)));
        this.eid = id;
    }

    @Override
    public Eid getEid() {
        return this.eid;
    }

    public Class<? extends RuntimeException> getStandardJdkClass() {
        return RuntimeException.class;
    }

    private static String message(Throwable cause) {
        String msg = EidRuntimeException.coalesce(cause.getLocalizedMessage(), cause.getMessage());
        return EidRuntimeException.coalesce(msg, cause.toString());
    }

    @Nullable
    private static <T> T coalesce(@Nullable T first, @Nullable T second) {
        if (first == null) {
            return second;
        }
        return first;
    }
}

