/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.exceptions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;

public class Eid
implements Serializable {
    public static final String DEFAULT_FORMAT = "[%s]<%s>";
    public static final String DEFAULT_REF_FORMAT = "[%s|%s]<%s>";
    public static final String DEFAULT_MESSAGE_FORMAT = "%s => %s";
    public static final UniqIdGenerator DEFAULT_UNIQ_ID_GENERATOR = new StdUniqIdGenerator();
    private static final long serialVersionUID = -9876432123423401L;
    private static final int FORMAT_NUM_SPEC = 2;
    private static final int REF_FORMAT_NUM_SPEC = 3;
    private static final int MESSAGE_FORMAT_NUM_SPEC = 2;
    private static final String EMPTY_REF = "";
    private static String messageFormat = "%s => %s";
    private static UniqIdGenerator uniqIdGenerator = DEFAULT_UNIQ_ID_GENERATOR;
    private static String format = "[%s]<%s>";
    private static String refFormat = "[%s|%s]<%s>";
    private final String id;
    private final String ref;
    private String uniqueId;

    public Eid(String id, @Nullable String ref) {
        this.id = id;
        this.ref = ref == null ? EMPTY_REF : ref;
    }

    public Eid(String id) {
        this.id = id;
        this.ref = EMPTY_REF;
    }

    public static String setMessageFormat(String format) {
        Eid.validateFormat(format, 2);
        String oldFormat = messageFormat;
        messageFormat = format;
        return oldFormat;
    }

    public static String getMessageFormat() {
        return messageFormat;
    }

    public static UniqIdGenerator setUniqIdGenerator(UniqIdGenerator uniqIdGenerator) {
        if (uniqIdGenerator == null) {
            throw new IllegalArgumentException("Unique ID generator can't be null, but given one");
        }
        UniqIdGenerator previous = Eid.uniqIdGenerator;
        Eid.uniqIdGenerator = uniqIdGenerator;
        return previous;
    }

    public static String setFormat(String format) {
        Eid.validateFormat(format, 2);
        String previously = Eid.format;
        Eid.format = format;
        return previously;
    }

    public static String setRefFormat(String refFormat) {
        Eid.validateFormat(refFormat, 3);
        String previously = Eid.refFormat;
        Eid.refFormat = refFormat;
        return previously;
    }

    public String makeLogMessage(String logMessageFormat, Object ... parameters) {
        String message = String.format(logMessageFormat, parameters);
        return String.format(Eid.getMessageFormat(), this.toString(), message);
    }

    public String toString() {
        if (EMPTY_REF.equals(this.ref)) {
            return String.format(format, this.id, this.getUniq());
        }
        return String.format(refFormat, this.id, this.ref, this.getUniq());
    }

    public String getId() {
        return this.id;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUniq() {
        if (this.uniqueId == null) {
            this.uniqueId = uniqIdGenerator.generateUniqId();
        }
        return this.uniqueId;
    }

    private static void validateFormat(String format, int numSpecifiers) {
        if (format == null) {
            throw new IllegalArgumentException("Format can't be null, but just received one");
        }
        ArrayList<String> specifiers = new ArrayList<String>();
        for (int i = 0; i < numSpecifiers; ++i) {
            specifiers.add(i + "-test-id");
        }
        String formatted = String.format(format, specifiers.toArray());
        for (String specifier : specifiers) {
            if (formatted.contains(specifier)) continue;
            throw new IllegalArgumentException("Given format contains to little format specifiers, expected " + numSpecifiers + " but given \"" + format + "\"");
        }
    }

    private static final class StdUniqIdGenerator
    implements UniqIdGenerator {
        private static final int BASE36 = 36;
        private final Random random = StdUniqIdGenerator.getUnsecuredFastRandom();

        private StdUniqIdGenerator() {
        }

        @Override
        public String generateUniqId() {
            long first = Math.abs(this.random.nextLong() + 1L);
            int second = Math.abs(this.random.nextInt(Integer.MAX_VALUE));
            int calc = (int)(first + (long)second);
            return Integer.toString(Math.abs(calc), 36);
        }

        private static Random getUnsecuredFastRandom() {
            return new Random(System.currentTimeMillis());
        }
    }

    public static interface UniqIdGenerator {
        public String generateUniqId();
    }
}

