/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PropertyManager {
    public static void putWithoutPrefix(@Nonnull Properties properties, String key, String value) {
        if (!PropertyManager.isNotEmpty(value)) {
            value = "Unknown";
        }
        properties.put(key, value);
    }

    private static boolean isNotEmpty(@Nullable String value) {
        return null != value && !" ".equals(value.trim().replaceAll(" ", ""));
    }

    public static Properties readProperties(@Nonnull File propertiesFile, @Nonnull Charset sourceCharset) throws Exception {
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            Properties properties;
            try (InputStreamReader reader = new InputStreamReader((InputStream)fis, sourceCharset);){
                Properties retVal = new Properties();
                retVal.load(reader);
                properties = retVal;
            }
            return properties;
        }
    }
}

