/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.variable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.sweetener.collection.Maps;
import pl.jsolve.templ4docx.exception.IncorrectNumberOfRowsException;
import pl.jsolve.templ4docx.util.Key;
import pl.jsolve.templ4docx.util.VariableType;
import pl.jsolve.templ4docx.variable.BulletListVariable;
import pl.jsolve.templ4docx.variable.ImageVariable;
import pl.jsolve.templ4docx.variable.TextVariable;
import pl.jsolve.templ4docx.variable.Variable;

public class TableOldVariable
implements Variable {
    private Map<String, List<TextVariable>> textVariables = Maps.newHashMap();
    private Map<String, List<ImageVariable>> imageVariables = Maps.newHashMap();
    private Map<String, List<BulletListVariable>> bulletListVariables = Maps.newHashMap();
    private int numberOfRows = 0;

    public void addTextVariables(String key, List<String> textVariables) {
        if (this.numberOfRows != 0) {
            if (textVariables.size() != this.numberOfRows) {
                throw new IncorrectNumberOfRowsException("Incorrect number of rows. Expected " + this.numberOfRows + " but was " + textVariables.size());
            }
        } else {
            this.numberOfRows = textVariables.size();
        }
        this.textVariables.put(key, this.convert(key, textVariables));
    }

    public void addTextVariables(String key, String ... textVariables) {
        if (this.numberOfRows != 0) {
            if (textVariables.length != this.numberOfRows) {
                throw new IncorrectNumberOfRowsException("Incorrect number of rows. Expected " + this.numberOfRows + " but was " + textVariables.length);
            }
        } else {
            this.numberOfRows = textVariables.length;
        }
        this.textVariables.put(key, this.convert(key, Arrays.asList(textVariables)));
    }

    private List<TextVariable> convert(String key, List<String> values) {
        ArrayList textValues = Collections.newArrayList();
        for (String value : values) {
            textValues.add(new TextVariable(key, value));
        }
        return textValues;
    }

    public void addImageVariables(String key, List<ImageVariable> imageVariables) {
        if (this.numberOfRows != 0) {
            if (imageVariables.size() != this.numberOfRows) {
                throw new IncorrectNumberOfRowsException("Incorrect number of rows. Expected " + this.numberOfRows + " but was " + imageVariables.size());
            }
        } else {
            this.numberOfRows = imageVariables.size();
        }
        this.imageVariables.put(key, imageVariables);
    }

    public void addImageVariables(String key, ImageVariable ... imageVariables) {
        if (this.numberOfRows != 0) {
            if (imageVariables.length != this.numberOfRows) {
                throw new IncorrectNumberOfRowsException("Incorrect number of rows. Expected " + this.numberOfRows + " but was " + imageVariables.length);
            }
        } else {
            this.numberOfRows = imageVariables.length;
        }
        this.imageVariables.put(key, Arrays.asList(imageVariables));
    }

    public void addBulletListVariables(String key, List<BulletListVariable> bulletListVariables) {
        if (this.numberOfRows != 0) {
            if (bulletListVariables.size() != this.numberOfRows) {
                throw new IncorrectNumberOfRowsException("Incorrect number of rows. Expected " + this.numberOfRows + " but was " + bulletListVariables.size());
            }
        } else {
            this.numberOfRows = bulletListVariables.size();
        }
        this.bulletListVariables.put(key, bulletListVariables);
    }

    public void addBulletListVariables(String key, BulletListVariable ... bulletListVariables) {
        if (this.numberOfRows != 0) {
            if (bulletListVariables.length != this.numberOfRows) {
                throw new IncorrectNumberOfRowsException("Incorrect number of rows. Expected " + this.numberOfRows + " but was " + bulletListVariables.length);
            }
        } else {
            this.numberOfRows = bulletListVariables.length;
        }
        this.bulletListVariables.put(key, Arrays.asList(bulletListVariables));
    }

    public Map<String, List<TextVariable>> getTextVariables() {
        return this.textVariables;
    }

    public Map<String, List<ImageVariable>> getImageVariables() {
        return this.imageVariables;
    }

    public Map<String, List<BulletListVariable>> getBulletListVariables() {
        return this.bulletListVariables;
    }

    public Set<Key> getKeys() {
        HashSet keys = Collections.newHashSet();
        this.generateKeys(keys, this.textVariables.keySet(), VariableType.TEXT);
        this.generateKeys(keys, this.imageVariables.keySet(), VariableType.IMAGE);
        this.generateKeys(keys, this.bulletListVariables.keySet(), VariableType.BULLET_LIST);
        return keys;
    }

    private void generateKeys(Set<Key> keys, Set<String> keysValues, VariableType variableType) {
        for (String keyValue : keysValues) {
            keys.add(new Key(keyValue, variableType));
        }
    }

    public boolean containsKey(String key) {
        return this.textVariables.containsKey(key) || this.imageVariables.containsKey(key) || this.bulletListVariables.containsKey(key);
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public Variable getVariable(Key key, int index) {
        switch (key.getVariableType()) {
            case TEXT: {
                return this.textVariables.get(key.getKey()).get(index);
            }
            case IMAGE: {
                return this.imageVariables.get(key.getKey()).get(index);
            }
            case BULLET_LIST: {
                return this.bulletListVariables.get(key.getKey()).get(index);
            }
        }
        return null;
    }
}

