/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.extractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.sweetener.collection.Maps;
import pl.jsolve.templ4docx.cleaner.ParagraphCleaner;
import pl.jsolve.templ4docx.cleaner.TableRowCleaner;
import pl.jsolve.templ4docx.extractor.KeyExtractor;
import pl.jsolve.templ4docx.insert.BulletListInsert;
import pl.jsolve.templ4docx.insert.ImageInsert;
import pl.jsolve.templ4docx.insert.Insert;
import pl.jsolve.templ4docx.insert.TableCellInsert;
import pl.jsolve.templ4docx.insert.TableRowInsert;
import pl.jsolve.templ4docx.insert.TextInsert;
import pl.jsolve.templ4docx.strategy.InsertStrategyChooser;
import pl.jsolve.templ4docx.util.Key;
import pl.jsolve.templ4docx.variable.Variables;

public class VariableFinder {
    private InsertStrategyChooser insertStrategyChooser;
    private TableRowCleaner tableRowCleaner = new TableRowCleaner();
    private ParagraphCleaner paragraphCleaner = new ParagraphCleaner();
    private KeyExtractor keyExtractor = new KeyExtractor();

    public VariableFinder(Variables variables) {
        this.insertStrategyChooser = new InsertStrategyChooser(variables, this.tableRowCleaner, this.paragraphCleaner);
    }

    public List<Insert> find(XWPFDocument document, Variables variables) {
        ArrayList inserts = Collections.newArrayList();
        List<Key> keys = this.keyExtractor.extractKeys(variables);
        for (XWPFParagraph paragraph : document.getParagraphs()) {
            inserts.addAll(this.find(paragraph, document, null, keys));
        }
        this.findInTables(inserts, document.getTables(), keys);
        this.mergeTableInserts(inserts, variables);
        return inserts;
    }

    private void findInTables(List<Insert> inserts, List<XWPFTable> tables, List<Key> keys) {
        for (XWPFTable tbl : tables) {
            for (XWPFTableRow row : tbl.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    if (!cell.getTables().isEmpty()) {
                        this.findInTables(inserts, cell.getTables(), keys);
                    }
                    for (XWPFParagraph paragraph : cell.getParagraphs()) {
                        inserts.addAll(this.find(paragraph, null, cell, keys));
                    }
                }
            }
        }
    }

    private List<Insert> find(XWPFParagraph paragraph, XWPFDocument document, XWPFTableCell cell, List<Key> keys) {
        ArrayList inserts = Collections.newArrayList();
        StringBuilder sb = new StringBuilder();
        for (XWPFRun run : paragraph.getRuns()) {
            sb.append(run.getText(0));
        }
        String paragraphText = sb.toString();
        for (Key key : keys) {
            if (!StringUtils.contains((CharSequence)paragraphText, (CharSequence)key.getKey())) continue;
            switch (key.getVariableType()) {
                case TEXT: {
                    inserts.add(new TextInsert(key, paragraph));
                    break;
                }
                case IMAGE: {
                    inserts.add(new ImageInsert(key, paragraph));
                    break;
                }
                case BULLET_LIST: {
                    inserts.add(new BulletListInsert(key, paragraph, cell, document));
                    break;
                }
                case TABLE: {
                    if (cell == null) break;
                    inserts.add(new TableCellInsert(key, cell));
                }
            }
        }
        return inserts;
    }

    private void mergeTableInserts(List<Insert> inserts, Variables variables) {
        HashMap rowInserts = Maps.newHashMap();
        ArrayList insertsToRemove = Collections.newArrayList();
        for (Insert insert : inserts) {
            if (!(insert instanceof TableCellInsert)) continue;
            TableCellInsert cellInsert = (TableCellInsert)insert;
            insertsToRemove.add(cellInsert);
            XWPFTableRow tableRow = cellInsert.getCell().getTableRow();
            if (rowInserts.containsKey(tableRow)) {
                TableRowInsert tableRowInsert = (TableRowInsert)rowInserts.get(tableRow);
                tableRowInsert.add(cellInsert);
                continue;
            }
            TableRowInsert rowInsert = new TableRowInsert();
            rowInsert.add(cellInsert);
            rowInserts.put(tableRow, rowInsert);
        }
        for (Insert insert : insertsToRemove) {
            inserts.remove(insert);
        }
        inserts.addAll(rowInserts.values());
    }

    public void replace(List<Insert> inserts) {
        for (Insert insert : inserts) {
            this.insertStrategyChooser.replace(insert);
        }
        this.insertStrategyChooser.cleanUp();
    }
}

