/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.cleaner;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import pl.jsolve.sweetener.text.Strings;
import pl.jsolve.templ4docx.core.Docx;
import pl.jsolve.templ4docx.core.VariablePattern;
import pl.jsolve.templ4docx.extractor.KeyExtractor;
import pl.jsolve.templ4docx.util.Key;
import pl.jsolve.templ4docx.variable.Variables;

public class DocumentCleaner {
    private KeyExtractor keyExtractor = new KeyExtractor();

    public void clean(Docx docx, Variables variables, VariablePattern variablePattern) {
        List<Key> keys = this.keyExtractor.extractKeys(variables);
        for (XWPFParagraph paragraph : docx.getXWPFDocument().getParagraphs()) {
            this.clean(paragraph.getRuns(), keys, variablePattern);
        }
        this.cleanTables(docx.getXWPFDocument().getTables(), keys, variablePattern);
    }

    private void cleanTables(List<XWPFTable> tables, List<Key> keys, VariablePattern variablePattern) {
        for (XWPFTable table : tables) {
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    for (XWPFParagraph paragraph : cell.getParagraphs()) {
                        if (!cell.getTables().isEmpty()) {
                            this.cleanTables(cell.getTables(), keys, variablePattern);
                        }
                        this.clean(paragraph.getRuns(), keys, variablePattern);
                    }
                }
            }
        }
    }

    private void clean(List<XWPFRun> runs, List<Key> keys, VariablePattern variablePattern) {
        if (runs == null || runs.isEmpty() || runs.size() == 1) {
            return;
        }
        String notRecognizedVariable = "";
        String notRecognizedPrefix = "";
        int notRecognizedVariableStartIndex = -1;
        for (int i = 0; i < runs.size(); ++i) {
            String prefix;
            List prefixIndexesOf;
            String text = runs.get(i).getText(0);
            if (text == null) continue;
            if (notRecognizedVariableStartIndex != -1) {
                List suffixIndexesOf = Strings.indexesOf((String)text, (String)variablePattern.getSuffix());
                if (!suffixIndexesOf.isEmpty()) {
                    notRecognizedVariable = notRecognizedVariable + text.substring(0, (Integer)suffixIndexesOf.get(0) + 1);
                    XWPFRun startRun = runs.get(notRecognizedVariableStartIndex);
                    boolean executeResult = this.containsKey(keys, notRecognizedVariable);
                    if (executeResult) {
                        String textFromStartRun = startRun.getText(0);
                        textFromStartRun = StringUtils.replace((String)textFromStartRun, (String)notRecognizedPrefix, (String)notRecognizedVariable);
                        startRun.setText(textFromStartRun, 0);
                        for (int j = notRecognizedVariableStartIndex + 1; j < i; ++j) {
                            runs.get(j).setText("", 0);
                        }
                        text = runs.get(i).getText(0);
                        Integer suffixIndex = (Integer)suffixIndexesOf.get(0);
                        runs.get(i).setText(text.substring(suffixIndex + 1), 0);
                        i = notRecognizedVariableStartIndex;
                    }
                    notRecognizedVariableStartIndex = -1;
                    notRecognizedVariable = "";
                    continue;
                }
                notRecognizedVariable = notRecognizedVariable + text;
            }
            if ((prefixIndexesOf = Strings.indexesOf((String)text, (String)(prefix = this.getFirstChar(variablePattern.getPrefix())))).isEmpty() || !Strings.indexesOf((String)text, (String)variablePattern.getSuffix()).isEmpty()) continue;
            notRecognizedVariableStartIndex = i;
            notRecognizedVariable = text;
            notRecognizedPrefix = text.substring((Integer)prefixIndexesOf.get(prefixIndexesOf.size() - 1));
        }
    }

    private boolean containsKey(List<Key> keys, String textContent) {
        for (Key key : keys) {
            if (!StringUtils.contains((CharSequence)textContent, (CharSequence)key.getKey())) continue;
            return true;
        }
        return false;
    }

    private String getFirstChar(String prefix) {
        if (prefix.length() == 1) {
            return prefix;
        }
        if (prefix.startsWith("\\") && prefix.length() > 1) {
            return prefix.substring(0, 2);
        }
        return prefix.substring(0, 1);
    }
}

