/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.variable;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.templ4docx.exception.IncorrectNumberOfRowsException;
import pl.jsolve.templ4docx.util.Key;
import pl.jsolve.templ4docx.util.VariableType;
import pl.jsolve.templ4docx.variable.BulletListVariable;
import pl.jsolve.templ4docx.variable.ImageVariable;
import pl.jsolve.templ4docx.variable.TextVariable;
import pl.jsolve.templ4docx.variable.Variable;

public class TableVariable
implements Variable {
    private List<List<? extends Variable>> variables = Collections.newArrayList();
    private int numberOfRows = 0;

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public List<List<? extends Variable>> getVariables() {
        return this.variables;
    }

    public void addVariable(List<? extends Variable> variable) {
        if (this.numberOfRows == 0) {
            this.numberOfRows = variable.size();
        } else if (this.numberOfRows != variable.size()) {
            throw new IncorrectNumberOfRowsException("Incorrect number of rows. Expected " + this.numberOfRows + " but was " + variable.size());
        }
        this.variables.add(variable);
    }

    public Set<Key> getKeys() {
        return this.extract(this.variables);
    }

    private Set<Key> extract(List<List<? extends Variable>> variables) {
        HashSet keys = Collections.newHashSet();
        for (List<? extends Variable> variable : variables) {
            if (variable.isEmpty()) break;
            Variable firstVariable = variable.get(0);
            if (firstVariable instanceof TextVariable) {
                keys.add(new Key(((TextVariable)firstVariable).getKey(), VariableType.TEXT));
                continue;
            }
            if (firstVariable instanceof ImageVariable) {
                keys.add(new Key(((ImageVariable)firstVariable).getKey(), VariableType.IMAGE));
                continue;
            }
            if (firstVariable instanceof BulletListVariable) {
                keys.add(new Key(((BulletListVariable)firstVariable).getKey(), VariableType.BULLET_LIST));
                continue;
            }
            if (!(firstVariable instanceof TableVariable)) continue;
            keys.addAll(this.extract(((TableVariable)firstVariable).getVariables()));
        }
        return keys;
    }

    public boolean containsKey(String key) {
        return this.containsKey(this.variables, key);
    }

    private boolean containsKey(List<List<? extends Variable>> variables, String key) {
        for (List<? extends Variable> variable : variables) {
            boolean containsKey;
            if (variable.isEmpty()) break;
            Variable firstVariable = variable.get(0);
            if (!(firstVariable instanceof TextVariable ? key.equals(((TextVariable)firstVariable).getKey()) : (firstVariable instanceof ImageVariable ? key.equals(((ImageVariable)firstVariable).getKey()) : (firstVariable instanceof BulletListVariable ? key.equals(((BulletListVariable)firstVariable).getKey()) : firstVariable instanceof TableVariable && (containsKey = this.containsKey(((TableVariable)firstVariable).getVariables(), key)))))) continue;
            return true;
        }
        return false;
    }

    public Variable getVariable(Key key, int index) {
        return this.getVariable(this.variables, key, index);
    }

    private Variable getVariable(List<List<? extends Variable>> variables, Key key, int index) {
        for (List<? extends Variable> variable : variables) {
            Variable foundVariable;
            if (variable.isEmpty() || variable.size() <= index) break;
            Variable firstVariable = variable.get(0);
            if (firstVariable instanceof TextVariable) {
                if (!key.getKey().equals(((TextVariable)firstVariable).getKey())) continue;
                return variable.get(index);
            }
            if (firstVariable instanceof ImageVariable) {
                if (!key.getKey().equals(((ImageVariable)firstVariable).getKey())) continue;
                return variable.get(index);
            }
            if (firstVariable instanceof BulletListVariable) {
                if (!key.getKey().equals(((BulletListVariable)firstVariable).getKey())) continue;
                return variable.get(index);
            }
            if (!(firstVariable instanceof TableVariable) || (foundVariable = this.getVariable(((TableVariable)firstVariable).getVariables(), key, index)) == null) continue;
            return foundVariable;
        }
        return null;
    }
}

