/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.variable;

import pl.jsolve.templ4docx.exception.UnsupportedImageTypeException;

public enum ImageType {
    EMF(2, "emf"),
    WMF(3, "wmf"),
    PICT(4, "pict"),
    JPEG(5, "jpeg"),
    JPG(5, "jpg"),
    PNG(6, "png"),
    DIB(7, "dib"),
    GIF(8, "gif"),
    TIFF(9, "tiff"),
    EPS(10, "eps"),
    BMP(11, "bmp"),
    WPG(12, "wpg");

    int imageType;
    String extension;

    private ImageType(int imageType, String extension) {
        this.imageType = imageType;
        this.extension = extension;
    }

    public int getImageType() {
        return this.imageType;
    }

    public String getExtension() {
        return this.extension;
    }

    public static ImageType findImageTypeForPath(String filePath) {
        filePath = filePath.toLowerCase();
        for (ImageType imageType : ImageType.values()) {
            if (!filePath.endsWith(imageType.extension)) continue;
            return imageType;
        }
        String[] splitPath = filePath.split("\\.");
        throw new UnsupportedImageTypeException(String.format("The %s extension is unsupported", splitPath[splitPath.length - 1]));
    }
}

