/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.extractor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import pl.jsolve.sweetener.collection.Collections;
import pl.jsolve.templ4docx.core.VariablePattern;

public class VariablesExtractor {
    public List<String> extract(String content, VariablePattern variablePattern) {
        ArrayList<String> tagValues = new ArrayList<String>();
        Pattern pattern = Pattern.compile(this.getFirstChar(variablePattern.getPrefix()) + "(.*?)" + this.getFirstChar(variablePattern.getSuffix()));
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            tagValues.add(matcher.group());
        }
        ArrayList filteredValues = Collections.newArrayList();
        for (String value : tagValues) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value}) || !StringUtils.startsWith((CharSequence)value, (CharSequence)variablePattern.getOriginalPrefix()) || !StringUtils.endsWith((CharSequence)value, (CharSequence)variablePattern.getOriginalSuffix())) continue;
            filteredValues.add(value);
        }
        return filteredValues;
    }

    private String getFirstChar(String prefix) {
        if (prefix.length() == 1) {
            return prefix;
        }
        if (prefix.startsWith("\\") && prefix.length() > 1) {
            return prefix.substring(0, 2);
        }
        return prefix.substring(0, 1);
    }
}

