/*
 * Decompiled with CFR 0.152.
 */
package pl.jsolve.templ4docx.core;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import pl.jsolve.sweetener.io.Resources;
import pl.jsolve.templ4docx.cleaner.DocumentCleaner;
import pl.jsolve.templ4docx.core.VariablePattern;
import pl.jsolve.templ4docx.exception.OpenDocxException;
import pl.jsolve.templ4docx.executor.DocumentExecutor;
import pl.jsolve.templ4docx.extractor.VariablesExtractor;
import pl.jsolve.templ4docx.variable.Variables;

public class Docx
implements Serializable {
    private static final long serialVersionUID = 1L;
    private VariablePattern variablePattern = new VariablePattern("${", "}");
    private String docxPath;
    private XWPFDocument docx = null;
    private DocumentCleaner documentCleaner;

    public Docx(String docxPath) {
        this.docxPath = docxPath;
        this.open();
        this.documentCleaner = new DocumentCleaner();
    }

    private void open() {
        try {
            FileInputStream fis = new FileInputStream(this.docxPath);
            this.docx = new XWPFDocument((InputStream)fis);
        }
        catch (Exception ex) {
            throw new OpenDocxException(ex.getMessage(), ex.getCause());
        }
    }

    public List<String> findVariables() {
        VariablesExtractor extractor = new VariablesExtractor();
        String content = this.readTextContent();
        return extractor.extract(content, this.variablePattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextContent() {
        XWPFWordExtractor extractor = null;
        try {
            extractor = new XWPFWordExtractor(this.docx);
            String string = extractor.getText();
            return string;
        }
        finally {
            if (extractor != null) {
                Resources.closeStream((Closeable)extractor);
            }
        }
    }

    public void fillTemplate(Variables variables) {
        this.documentCleaner.clean(this, variables, this.variablePattern);
        DocumentExecutor documentExecutor = new DocumentExecutor(variables);
        documentExecutor.execute(this);
    }

    public void save(String outputPath) {
        try {
            this.docx.write((OutputStream)new FileOutputStream(outputPath));
        }
        catch (Exception ex) {
            throw new OpenDocxException(ex.getMessage(), ex.getCause());
        }
    }

    public void save(OutputStream outputStream) {
        try {
            this.docx.write(outputStream);
        }
        catch (Exception ex) {
            throw new OpenDocxException(ex.getMessage(), ex.getCause());
        }
    }

    public void setVariablePattern(VariablePattern variablePattern) {
        this.variablePattern = variablePattern;
    }

    public XWPFDocument getXWPFDocument() {
        return this.docx;
    }
}

