/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.mongo;

import java.util.List;
import lombok.NonNull;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import pl.execon.fsp.core.FspRequest;
import pl.execon.fsp.core.FspResponse;
import pl.execon.fsp.mongo.MongoFsp;
import pl.execon.fsp.mongo.MongoFspRequestResolver;

class MongoFspImpl<T>
implements MongoFsp<T> {
    @NonNull
    private MongoTemplate mongoTemplate;

    @Override
    public FspResponse<T> findFsp(FspRequest request, Class<T> documentClass) {
        Query query = new MongoFspRequestResolver(request).asQuery();
        List list = this.mongoTemplate.find(query, documentClass);
        if (!request.hasPageInfo()) {
            return new FspResponse(list);
        }
        long count = this.mongoTemplate.count(query.limit(-1).skip(-1L), documentClass);
        return new FspResponse(request, list, count);
    }

    public MongoFspImpl(@NonNull MongoTemplate mongoTemplate) {
        if (mongoTemplate == null) {
            throw new NullPointerException("mongoTemplate is marked non-null but is null");
        }
        this.mongoTemplate = mongoTemplate;
    }
}

