/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class LongLargeArray
extends LargeArray {
    private static final long serialVersionUID = -2579271120060523901L;
    private long[] data;

    public LongLargeArray(long l) {
        this(l, true);
    }

    public LongLargeArray(long l, boolean bl) {
        this.type = LargeArrayType.LONG;
        this.sizeof = 8L;
        if (l <= 0L) {
            throw new IllegalArgumentException(l + " is not a positive long value");
        }
        this.length = l;
        if (l > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (bl) {
                this.zeroNativeMemory(l);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new long[(int)l];
        }
    }

    public LongLargeArray(long l, long l2) {
        this.type = LargeArrayType.DOUBLE;
        this.sizeof = 8L;
        if (l <= 0L) {
            throw new IllegalArgumentException(l + " is not a positive long value");
        }
        this.length = l;
        this.isConstant = true;
        this.data = new long[]{l2};
    }

    public LongLargeArray(long[] lArray) {
        this.type = LargeArrayType.LONG;
        this.sizeof = 8L;
        this.length = lArray.length;
        this.data = lArray;
    }

    @Override
    public LongLargeArray clone() {
        if (this.isConstant()) {
            return new LongLargeArray(this.length, this.getLong(0L));
        }
        LongLargeArray longLargeArray = new LongLargeArray(this.length, false);
        Utilities.arraycopy(this, 0L, longLargeArray, 0L, this.length);
        return longLargeArray;
    }

    @Override
    public Long get(long l) {
        return this.getLong(l);
    }

    @Override
    public Long getFromNative(long l) {
        return Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l);
    }

    @Override
    public boolean getBoolean(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l) != 0L;
        }
        if (this.isConstant()) {
            return this.data[0] != 0L;
        }
        return this.data[(int)l] != 0L;
    }

    @Override
    public byte getByte(long l) {
        if (this.ptr != 0L) {
            return (byte)Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l);
        }
        if (this.isConstant()) {
            return (byte)this.data[0];
        }
        return (byte)this.data[(int)l];
    }

    @Override
    public short getShort(long l) {
        if (this.ptr != 0L) {
            return (short)Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l);
        }
        if (this.isConstant()) {
            return (short)this.data[0];
        }
        return (short)this.data[(int)l];
    }

    @Override
    public int getInt(long l) {
        if (this.ptr != 0L) {
            return (int)Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l);
        }
        if (this.isConstant()) {
            return (int)this.data[0];
        }
        return (int)this.data[(int)l];
    }

    @Override
    public long getLong(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)l];
    }

    @Override
    public float getFloat(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)l];
    }

    @Override
    public double getDouble(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getLong(this.ptr + this.sizeof * l);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)l];
    }

    public long[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            long[] lArray = new long[(int)this.length];
            int n = 0;
            while ((long)n < this.length) {
                lArray[n] = this.data[0];
                ++n;
            }
            return lArray;
        }
        return this.data;
    }

    @Override
    public boolean[] getBooleanData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            boolean[] blArray = new boolean[(int)this.length];
            boolean bl = this.data[0] != 0L;
            int n = 0;
            while ((long)n < this.length) {
                blArray[n] = bl;
                ++n;
            }
            return blArray;
        }
        boolean[] blArray = new boolean[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            blArray[n] = this.data[n] != 0L;
            ++n;
        }
        return blArray;
    }

    @Override
    public boolean[] getBooleanData(boolean[] blArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        boolean[] blArray2 = blArray != null && (long)blArray.length >= l4 ? blArray : new boolean[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                long l5 = Utilities.UNSAFE.getLong(this.ptr + this.sizeof * i);
                blArray2[n++] = l5 != 0L;
            }
        } else if (this.isConstant()) {
            for (long i = l; i < l2; i += l3) {
                blArray2[n++] = this.data[0] != 0L;
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                long l6 = this.data[(int)i];
                blArray2[n++] = l6 != 0L;
            }
        }
        return blArray2;
    }

    @Override
    public byte[] getByteData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            byte[] byArray = new byte[(int)this.length];
            byte by = (byte)this.data[0];
            int n = 0;
            while ((long)n < this.length) {
                byArray[n] = by;
                ++n;
            }
            return byArray;
        }
        byte[] byArray = new byte[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            byArray[n] = (byte)this.data[n];
            ++n;
        }
        return byArray;
    }

    @Override
    public byte[] getByteData(byte[] byArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        byte[] byArray2 = byArray != null && (long)byArray.length >= l4 ? byArray : new byte[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                byArray2[n++] = (byte)Utilities.UNSAFE.getLong(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = l; i < l2; i += l3) {
                byArray2[n++] = (byte)this.data[0];
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                byArray2[n++] = (byte)this.data[(int)i];
            }
        }
        return byArray2;
    }

    @Override
    public short[] getShortData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            short[] sArray = new short[(int)this.length];
            short s = (short)this.data[0];
            int n = 0;
            while ((long)n < this.length) {
                sArray[n] = s;
                ++n;
            }
            return sArray;
        }
        short[] sArray = new short[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            sArray[n] = (short)this.data[n];
            ++n;
        }
        return sArray;
    }

    @Override
    public short[] getShortData(short[] sArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        short[] sArray2 = sArray != null && (long)sArray.length >= l4 ? sArray : new short[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                sArray2[n++] = (short)Utilities.UNSAFE.getLong(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = l; i < l2; i += l3) {
                sArray2[n++] = (short)this.data[0];
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                sArray2[n++] = (short)this.data[(int)i];
            }
        }
        return sArray2;
    }

    @Override
    public int[] getIntData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            int[] nArray = new int[(int)this.length];
            int n = (int)this.data[0];
            int n2 = 0;
            while ((long)n2 < this.length) {
                nArray[n2] = n;
                ++n2;
            }
            return nArray;
        }
        int[] nArray = new int[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            nArray[n] = (int)this.data[n];
            ++n;
        }
        return nArray;
    }

    @Override
    public int[] getIntData(int[] nArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        int[] nArray2 = nArray != null && (long)nArray.length >= l4 ? nArray : new int[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                nArray2[n++] = (int)Utilities.UNSAFE.getLong(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = l; i < l2; i += l3) {
                nArray2[n++] = (int)this.data[0];
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                nArray2[n++] = (int)this.data[(int)i];
            }
        }
        return nArray2;
    }

    @Override
    public long[] getLongData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            long[] lArray = new long[(int)this.length];
            long l = this.data[0];
            int n = 0;
            while ((long)n < this.length) {
                lArray[n] = l;
                ++n;
            }
            return lArray;
        }
        return (long[])this.data.clone();
    }

    @Override
    public long[] getLongData(long[] lArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        long[] lArray2 = lArray != null && (long)lArray.length >= l4 ? lArray : new long[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                lArray2[n++] = Utilities.UNSAFE.getLong(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = l; i < l2; i += l3) {
                lArray2[n++] = this.data[0];
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                lArray2[n++] = this.data[(int)i];
            }
        }
        return lArray2;
    }

    @Override
    public float[] getFloatData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            float[] fArray = new float[(int)this.length];
            float f = this.data[0];
            int n = 0;
            while ((long)n < this.length) {
                fArray[n] = f;
                ++n;
            }
            return fArray;
        }
        float[] fArray = new float[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            fArray[n] = this.data[n];
            ++n;
        }
        return fArray;
    }

    @Override
    public float[] getFloatData(float[] fArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] fArray2 = fArray != null && (long)fArray.length >= l4 ? fArray : new float[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                fArray2[n++] = Utilities.UNSAFE.getLong(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = l; i < l2; i += l3) {
                fArray2[n++] = this.data[0];
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                fArray2[n++] = this.data[(int)i];
            }
        }
        return fArray2;
    }

    @Override
    public double[] getDoubleData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            double[] dArray = new double[(int)this.length];
            double d = this.data[0];
            int n = 0;
            while ((long)n < this.length) {
                dArray[n] = d;
                ++n;
            }
            return dArray;
        }
        double[] dArray = new double[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            dArray[n] = this.data[n];
            ++n;
        }
        return dArray;
    }

    @Override
    public double[] getDoubleData(double[] dArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)LongLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        double[] dArray2 = dArray != null && (long)dArray.length >= l4 ? dArray : new double[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                dArray2[n++] = Utilities.UNSAFE.getLong(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = l; i < l2; i += l3) {
                dArray2[n++] = this.data[0];
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                dArray2[n++] = this.data[(int)i];
            }
        }
        return dArray2;
    }

    @Override
    public void setToNative(long l, Object object) {
        Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, (Long)object);
    }

    @Override
    public void setBoolean(long l, boolean bl) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, bl ? 1L : 0L);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)l] = bl ? 1L : 0L;
        }
    }

    @Override
    public void setByte(long l, byte by) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, by);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)l] = by;
        }
    }

    @Override
    public void setShort(long l, short s) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, s);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)l] = s;
        }
    }

    @Override
    public void setInt(long l, int n) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, n);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)l] = n;
        }
    }

    @Override
    public void setLong(long l, long l2) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, l2);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)l] = l2;
        }
    }

    @Override
    public void setFloat(long l, float f) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, (long)f);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)l] = (long)f;
        }
    }

    @Override
    public void setDouble(long l, double d) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putLong(this.ptr + this.sizeof * l, (long)d);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)l] = (long)d;
        }
    }
}

