/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.relinker;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import pl.droidsonroids.relinker.ApkLibraryInstaller;
import pl.droidsonroids.relinker.MissingLibraryException;
import pl.droidsonroids.relinker.ReLinker;
import pl.droidsonroids.relinker.SystemLibraryLoader;
import pl.droidsonroids.relinker.TextUtils;
import pl.droidsonroids.relinker.elf.ElfParser;

public class ReLinkerInstance {
    private static final String LIB_DIR = "lib";
    protected final Set<String> loadedLibraries = new HashSet<String>();
    protected final ReLinker.LibraryLoader libraryLoader;
    protected final ReLinker.LibraryInstaller libraryInstaller;
    protected boolean force;
    protected boolean recursive;
    protected ReLinker.Logger logger;

    protected ReLinkerInstance() {
        this(new SystemLibraryLoader(), new ApkLibraryInstaller());
    }

    protected ReLinkerInstance(ReLinker.LibraryLoader libraryLoader, ReLinker.LibraryInstaller libraryInstaller) {
        if (libraryLoader == null) {
            throw new IllegalArgumentException("Cannot pass null library loader");
        }
        if (libraryInstaller == null) {
            throw new IllegalArgumentException("Cannot pass null library installer");
        }
        this.libraryLoader = libraryLoader;
        this.libraryInstaller = libraryInstaller;
    }

    public ReLinkerInstance log(ReLinker.Logger logger) {
        this.logger = logger;
        return this;
    }

    public ReLinkerInstance force() {
        this.force = true;
        return this;
    }

    public ReLinkerInstance recursively() {
        this.recursive = true;
        return this;
    }

    public void loadLibrary(Context context, String library) {
        this.loadLibrary(context, library, null, null);
    }

    public void loadLibrary(Context context, String library, String version) {
        this.loadLibrary(context, library, version, null);
    }

    public void loadLibrary(Context context, String library, ReLinker.LoadListener listener) {
        this.loadLibrary(context, library, null, listener);
    }

    public void loadLibrary(final Context context, final String library, final String version, final ReLinker.LoadListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("Given context is null");
        }
        if (TextUtils.isEmpty(library)) {
            throw new IllegalArgumentException("Given library is either null or empty");
        }
        this.log("Beginning load of %s...", library);
        if (listener == null) {
            this.loadLibraryInternal(context, library, version);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReLinkerInstance.this.loadLibraryInternal(context, library, version);
                        listener.success();
                    }
                    catch (UnsatisfiedLinkError e) {
                        listener.failure(e);
                    }
                    catch (MissingLibraryException e) {
                        listener.failure(e);
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLibraryInternal(Context context, String library, String version) {
        if (this.loadedLibraries.contains(library) && !this.force) {
            this.log("%s already loaded previously!", library);
            return;
        }
        try {
            this.libraryLoader.loadLibrary(library);
            this.loadedLibraries.add(library);
            this.log("%s (%s) was loaded normally!", library, version);
            return;
        }
        catch (UnsatisfiedLinkError e) {
            File workaroundFile;
            block11: {
                this.log("Loading the library normally failed: %s", Log.getStackTraceString((Throwable)e));
                this.log("%s (%s) was not loaded normally, re-linking...", library, version);
                workaroundFile = this.getWorkaroundLibFile(context, library, version);
                if (!workaroundFile.exists() || this.force) {
                    if (this.force) {
                        this.log("Forcing a re-link of %s (%s)...", library, version);
                    }
                    this.cleanupOldLibFiles(context, library, version);
                    this.libraryInstaller.installLibrary(context, this.libraryLoader.supportedAbis(), this.libraryLoader.mapLibraryName(library), workaroundFile, this);
                }
                try {
                    List<String> dependencies;
                    if (!this.recursive) break block11;
                    ElfParser parser = null;
                    try {
                        parser = new ElfParser(workaroundFile);
                        dependencies = parser.parseNeededDependencies();
                    }
                    finally {
                        parser.close();
                    }
                    for (String dependency : dependencies) {
                        this.loadLibrary(context, this.libraryLoader.unmapLibraryName(dependency));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.libraryLoader.loadPath(workaroundFile.getAbsolutePath());
            this.loadedLibraries.add(library);
            this.log("%s (%s) was re-linked!", library, version);
            return;
        }
    }

    protected File getWorkaroundLibDir(Context context) {
        return context.getDir(LIB_DIR, 0);
    }

    protected File getWorkaroundLibFile(Context context, String library, String version) {
        String libName = this.libraryLoader.mapLibraryName(library);
        if (TextUtils.isEmpty(version)) {
            return new File(this.getWorkaroundLibDir(context), libName);
        }
        return new File(this.getWorkaroundLibDir(context), libName + "." + version);
    }

    protected void cleanupOldLibFiles(Context context, String library, String currentVersion) {
        File workaroundDir = this.getWorkaroundLibDir(context);
        File workaroundFile = this.getWorkaroundLibFile(context, library, currentVersion);
        final String mappedLibraryName = this.libraryLoader.mapLibraryName(library);
        File[] existingFiles = workaroundDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(mappedLibraryName);
            }
        });
        if (existingFiles == null) {
            return;
        }
        for (File file : existingFiles) {
            if (!this.force && file.getAbsolutePath().equals(workaroundFile.getAbsolutePath())) continue;
            file.delete();
        }
    }

    public void log(String format, Object ... args) {
        this.log(String.format(Locale.US, format, args));
    }

    public void log(String message) {
        if (this.logger != null) {
            this.logger.log(message);
        }
    }
}

