package pl.decerto.hyperon.persistence.sync.diff;

import pl.decerto.hyperon.persistence.model.def.PropertyDef;
import pl.decerto.hyperon.persistence.model.value.ValueProperty;

/**
 * @author przemek hertel
 */
public class ValueDiff {

	private final PropertyDef def;
	private final String name;
	private final ValueProperty prev;
	private final ValueProperty next;

	public ValueDiff(PropertyDef def, String name, ValueProperty prev, ValueProperty next) {
		this.def = def;
		this.name = name;
		this.prev = prev;
		this.next = next;
	}

	public String getName() {
		return name;
	}

	public ValueProperty getNext() {
		return next;
	}

	public ValueProperty getPrev() {
		return prev;
	}

	public PropertyDef getDef() {
		return def;
	}

	@Override
	public String toString() {
		return getName() + ":" + str(getPrev()) + "->" + str(getNext());
	}

	private String str(ValueProperty v) {
		return v != null ? v.getString() : null;
	}

}
