package pl.decerto.hyperon.persistence.marshaller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

/**
 * @author przemek hertel
 */
public final class ExpRef {

	private long id;
	private long ownerId;
	private String ownerProperty;

	@JsonCreator ExpRef(@JsonProperty("id") long id, @JsonProperty("ownerId") long ownerId, @JsonProperty("ownerProperty") String ownerProperty) {
		this.id = id;
		this.ownerId = ownerId;
		this.ownerProperty = ownerProperty;
	}

	public long getId() {
		return id;
	}

	public long getOwnerId() {
		return ownerId;
	}

	public String getOwnerProperty() {
		return ownerProperty;
	}

	@Override public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof ExpRef)) {
			return false;
		}
		ExpRef expRef = (ExpRef) o;
		return id == expRef.id &&
			ownerId == expRef.ownerId &&
			Objects.equals(ownerProperty, expRef.ownerProperty);
	}

	@Override public int hashCode() {
		return Objects.hash(id, ownerId, ownerProperty);
	}

	@Override public String toString() {
		return "ExpRef{" +
			"id=" + id +
			", ownerId=" + ownerId +
			", ownerProperty='" + ownerProperty + '\'' +
			'}';
	}

}
