// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.helper;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.persistence.dao.BundleHeader;
import pl.decerto.hyperon.persistence.dao.Tuple;
import pl.decerto.hyperon.persistence.dao.TupleProperty;
import pl.decerto.hyperon.persistence.marshaller.ExpFragment;
import pl.decerto.hyperon.persistence.marshaller.ExpRef;
import pl.decerto.hyperon.persistence.marshaller.LobData;
import pl.decerto.hyperon.persistence.model.def.BundleDef;
import pl.decerto.hyperon.persistence.model.def.EntityType;
import pl.decerto.hyperon.persistence.model.def.PropertyDef;
import pl.decerto.hyperon.persistence.model.value.Bundle;
import pl.decerto.hyperon.persistence.model.value.CollectionProperty;
import pl.decerto.hyperon.persistence.model.value.ElementType;
import pl.decerto.hyperon.persistence.model.value.EntityProperty;
import pl.decerto.hyperon.persistence.model.value.Property;
import pl.decerto.hyperon.persistence.model.value.RefProperty;
import pl.decerto.hyperon.persistence.model.value.ValueProperty;
import pl.decerto.hyperon.runtime.helper.TypeConverter;

/**
 * @author przemek hertel
 */
public class BundleHelper {
	@java.lang.SuppressWarnings("all")
	private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(BundleHelper.class);

	private BundleHelper() {
		throw new IllegalStateException("Shouldn\'t create instance of this class.");
	}

	public static final TypeConverter type = new TypeConverter();

	/**
	 * Reconstruct bundle from
	 * - header fields [header]
	 * - unmarshalled entity fragments [lob]
	 * - unmarshalled root fragment [lob]
	 * - refs [lob]
	 * - database records [tuples]
	 *
	 * @param def    bundle definition
	 * @param header bundle header (bid, revision, extra fields)
	 * @param lob    data unmarshalled from json
	 * @param tuples database records
	 * @return bundle created from merging definition, header and lob data
	 */
	public static Bundle merge(BundleDef def, BundleHeader header, LobData lob, List<Tuple> tuples) {
		long bid = header.getId();
		int revision = header.getRevision();
		log.trace("creating bundle with id:{} and revision:{}", bid, revision);
		BundleData data = getBundleData(def, lob);
		// move each database record to [data]
		addTupleData(tuples, data);
		// reconstruct bundle tree from [data]
		Bundle bundle = merge(bid, revision, def, data);
		fillHeaderExtraFields(header, lob, bundle);
		reconstructReferences(lob, bundle);
		return bundle;
	}

	private static void reconstructReferences(LobData lob, Bundle bundle) {
		List<ExpRef> refs = lob.getRefs();
		log.debug("reconstructing {} references in bundle id:{}", refs.size(), bundle.getId());
		Instant start = Instant.now();
		for (ExpRef e : refs) {
			log.trace("reconstructing reference:{}", e);
			reconstructReference(bundle, e);
		}
		log.debug("reconstructing references in bundle id:{} finished", bundle.getId());
		if (log.isTraceEnabled()) {
			log.trace("execution time:{} ms", getExecutionTimeMillis(start));
		}
	}

	private static void reconstructReference(Bundle bundle, ExpRef ref) {
		// this ref's target
		long targetId = ref.getId();
		Property target = bundle.find(targetId);
		// this ref's holder
		Property owner = bundle.find(ref.getOwnerId());
		Property holder = owner.get(ref.getOwnerProperty());
		// set ref on this holder
		if (holder.isCollection()) {
			holder.add(target);
		} else {
			holder.set(target);
		}
	}

	private static void fillHeaderExtraFields(BundleHeader header, LobData lob, Bundle bundle) {
		log.debug("filling extra header fields in bundle id:{}", bundle.getId());
		// optional root extra fields in tuple
		if (header.getTuple() != null) {
			fillHeaderExtraFields(bundle, header.getTuple());
		}
		// optional root extra fields in json
		if (lob.getRoot() != null) {
			fillHeaderExtraFields(lob, bundle);
		}
		log.debug("filling extra header fields in bundle id:{} finished", bundle.getId());
	}

	private static void fillHeaderExtraFields(LobData lob, Bundle bundle) {
		if (log.isTraceEnabled()) {
			log.trace("filling extra fields in header from lob data:{}", lob);
		}
		lob.getRoot().getF().forEach(bundle::set);
		log.trace("filling extra fields in header from lob data finished");
	}

	private static BundleData getBundleData(BundleDef def, LobData lob) {
		log.trace("adding data from generic json");
		Instant start = Instant.now();
		BundleData data = buildBundleData(def, lob);
		if (log.isTraceEnabled()) {
			log.trace("adding data from generic json finished, time:{} ms", getExecutionTimeMillis(start));
		}
		return data;
	}

	private static long getExecutionTimeMillis(Instant start) {
		return Duration.between(start, Instant.now()).toMillis();
	}

	private static void addTupleData(List<Tuple> tuples, BundleData data) {
		log.debug("adding data from fetched tuples");
		Instant start = Instant.now();
		for (Tuple t : tuples) {
			data.add(t);
		}
		log.debug("adding data from fetched tuples finished");
		if (log.isTraceEnabled()) {
			log.trace("execution time:{}", getExecutionTimeMillis(start));
		}
	}

	public static BundleData buildBundleData(BundleDef def, LobData lob) {
		List<ExpFragment> fragments = lob.getEntities();
		// auxiliary container
		BundleData data = new BundleData();
		// move each fragment entity to [data]
		for (ExpFragment frag : fragments) {
			if (log.isTraceEnabled()) {
				log.trace("constructing entity from fragment:{}", frag);
			}
			if (def.findType(frag.getType()) == null) {
				continue;
			}
			EntityProperty ep = createEntityPropertyFromGenericFragments(def, frag);
			if (log.isTraceEnabled()) {
				log.trace("constructed entity property:{}", ep);
			}
			data.add(ep);
		}
		return data;
	}

	private static EntityProperty createEntityPropertyFromGenericFragments(BundleDef def, ExpFragment frag) {
		// create standalone entity from [frag]
		EntityProperty ep = createEntity(frag.getId(), def.findType(frag.getType()), frag.getPid(), frag.getName());
		// reconstruct each field from [frag] entity
		for (Map.Entry<String, String> entry : frag.getF().entrySet()) {
			String fieldName = entry.getKey();
			String fieldValue = entry.getValue();
			reconstructEntityField(ep, fieldName, fieldValue);
		}
		return ep;
	}

	private static void reconstructEntityField(EntityProperty ep, String fieldName, String fieldValue) {
		log.trace("reconstructing field:{} with value:{} in entity with id:{}", fieldName, fieldValue, ep.getId());
		// convert field value to ValueHolder
		PropertyDef propDef = ep.getType().getCompoundType().getProp(fieldName);
		if (propDef != null) {
			log.trace("found property definition:{}", propDef);
			String simpleType = propDef.getSimpleType();
			log.trace("fieldName:{} has type:{}", fieldName, simpleType);
			ValueHolder value = type.toHolder(fieldValue, simpleType);
			// create ValueProperty field
			ValueProperty valueProperty = new ValueProperty(simpleType, value);
			if (log.isTraceEnabled()) {
				log.trace("constructed value property:{}", valueProperty);
			}
			ep.add(fieldName, valueProperty);
		}
	}

	private static void fillHeaderExtraFields(Bundle b, Tuple t) {
		if (log.isTraceEnabled()) {
			log.trace("filling extra fields in header from tuple:{}", t);
		}
		for (TupleProperty tp : t.getProperties()) {
			log.trace("setting header field:{} with value:{}", tp.getPropertyName(), tp.getValue());
			b.set(tp.getPropertyName(), tp.getValue());
		}
		log.trace("filling extra fields in header from tuple finished");
	}

	private static Bundle merge(long bundleId, int revision, BundleDef bundleDef, BundleData data) {
		log.debug("merging all data for bundleId:{} and revision:{}", bundleId, revision);
		Instant start = Instant.now();
		Map<Long, EntityProperty> result = initMergeWithShallowCopy(data);
		fillEntitiesWithTupleData(data, result);
		Bundle b = new Bundle(bundleDef, bundleId, revision);
		// reconstruct each node (EntityProperty, CollectionProperty) recursively
		reconstructAllProperties(b, bundleDef, data);
		log.debug("merging all data for bundleId:{} and revision:{} finished", bundleId, revision);
		if (log.isTraceEnabled()) {
			log.trace("execution time:{}", getExecutionTimeMillis(start));
		}
		return b;
	}

	private static void fillEntitiesWithTupleData(BundleData data, Map<Long, EntityProperty> result) {
		Collection<Tuple> tuples = data.getTupleMap().values();
		log.trace("adding info from tuples, tuples size:{}", tuples.size());
		Instant startTime = Instant.now();
		for (Tuple t : tuples) {
			long id = t.getId();
			if (log.isTraceEnabled()) {
				log.trace("filling from tuple:{}", t);
			}
			EntityProperty prop = result.get(id);
			if (prop == null) {
				prop = createEntityFromTuple(t);
				result.put(id, prop);
			} else {
				if (t.getCollectionName() != null) {
					prop.setName(t.getCollectionName());
				}
			}
			// fill
			fillValueFields(t.getProperties(), prop);
		}
		if (log.isTraceEnabled()) {
			log.trace("filling tuple data finished, time:{} ms", getExecutionTimeMillis(startTime));
		}
	}

	private static EntityProperty createEntityFromTuple(Tuple t) {
		return createEntity(t.getId(), t.getDef().getEntityType(), t.getOwnerId(), t.getCollectionName());
	}

	private static EntityProperty createEntity(long id, EntityType entityType, long ownerId, String name) {
		EntityProperty prop = new EntityProperty(id, entityType);
		prop.setOwnerId(ownerId);
		prop.setName(name);
		return prop;
	}

	private static void fillValueFields(List<TupleProperty> properties, EntityProperty prop) {
		for (TupleProperty field : properties) {
			ValueProperty value = new ValueProperty(field.getType(), field.getValue());
			prop.add(field.getPropertyName(), value);
		}
	}

	private static Map<Long, EntityProperty> initMergeWithShallowCopy(BundleData data) {
		// all detected properties
		Collection<EntityProperty> props = data.getPropMap().values();
		// result properties
		Map<Long, EntityProperty> result = data.getResult();
		log.debug("initializing merge with entities shallow copy");
		Instant startTime = Instant.now();
		// init result properties as shallow copy of detected ones
		for (EntityProperty ep : props) {
			EntityProperty prop = shallowCopy(ep);
			result.put(prop.getId(), prop);
		}
		log.debug("initializing merge with entities shallow copy finished");
		if (log.isTraceEnabled()) {
			log.trace("execution time:{} ms", getExecutionTimeMillis(startTime));
		}
		return result;
	}

	private static EntityProperty shallowCopy(EntityProperty ep) {
		if (log.isTraceEnabled()) {
			log.trace("creating shallow copy of entity property:{}", ep);
		}
		EntityProperty copy = new EntityProperty(ep.getId(), ep.getType().getCompoundType());
		for (Map.Entry<String, Property> e : ep.getFields().entrySet()) {
			if (e.getValue().isValue()) {
				String name = e.getKey();
				ValueProperty value = e.getValue().asValue();
				copy.add(name, value.deepcopy(false));
			}
		}
		copy.setName(ep.getName());
		copy.setOwnerId(ep.getOwnerId());
		if (log.isTraceEnabled()) {
			log.trace("created shallow copy:{}", copy);
		}
		return copy;
	}

	private static void reconstructAllProperties(EntityProperty prop, EntityType def, BundleData data) {
		long propId = prop.getId();
		Map<String, PropertyDef> propDefs = def.getProps();
		propDefs.forEach((name, propDef) -> {
			if (log.isTraceEnabled()) {
				log.trace("reconstructing property:{} with definition:{}", name, propDef);
			}
			if (propDef.isCollection() && propDef.isEntityType()) {
				log.trace("reconstructing collection property with name:{}", name);
				CollectionProperty coll = createCollectionProperty(name, propDef);
				List<EntityProperty> elements = data.findCollectionElements(propId, name);
				for (EntityProperty element : elements) {
					reconstructAllProperties(element, propDef.getComponentDef().getEntityType(), data);
					coll.add(element);
				}
				log.trace("collection property with name:{} reconstructed", name);
				prop.add(name, coll);
			}
			if (!propDef.isCollection()) {
				if (propDef.isEntityType()) {
					log.trace("reconstructing entity property with name:{}", name);
					EntityType entityType = propDef.getEntityType();
					// find child by (parentId, type, name)
					EntityProperty child = data.findEntityProperty(propId, entityType, name);
					if (child != null) {
						if (log.isTraceEnabled()) {
							log.trace("found existing entity property:{}", child);
						}
						prop.add(name, child);
						reconstructAllProperties(child, entityType, data);
					}
					log.trace("entity property with name:{} reconstructed", name);
				} else if (propDef.isSimpleType()) {
					log.trace("reconstructing simple property with name:{}", name);
					Property field = data.findSimpleProperty(propId, prop.getName(), def.getName(), propDef.getSimpleType(), name);
					if (field != null) {
						if (log.isTraceEnabled()) {
							log.trace("found existing property:{}", field);
						}
						prop.add(name, field);
					}
					log.trace("simple property with name:{} reconstructed", name);
				}
			}
		});
	}

	private static CollectionProperty createCollectionProperty(String name, PropertyDef propDef) {
		CollectionProperty coll = new CollectionProperty(propDef.getType());
		coll.setName(name);
		return coll;
	}

	public static int computeHash(Property prop) {
		final List<Integer> list = new ArrayList<>();
		BundleWalker.walk(prop, new PropertyVisitor() {
			@Override
			public void visit(Property p, String path, ElementType type) {
				throw new UnsupportedOperationException();
			}
			@Override
			public void visit(Property p, ElementType type) {
				if (p.isRef() || p.isValue() || p.isEntity()) {
					// common attributes
					int hash = Objects.hash(p.getId(), p.getPath(), type);
					if (p.isRef()) {
						list.add(Objects.hash(hash, p.getOwnerId(), p.getOwnerPropertyName(), p.getRefTarget().getRefCount()));
					} else if (p.isValue() && notnull(p.asValue())) {
						list.add(Objects.hash(hash, hash(p.asValue())));
					} else if (p.isEntity()) {
						list.add(Objects.hash(hash, p.getOwnerId(), p.getOwnerPropertyName(), p.getParentName(), p.getTypeCode()));
					}
				}
			}
		}, false);
		Collections.sort(list);
		return Objects.hash(list.toArray());
	}

	private static int hash(ValueProperty p) {
		return p != null && p.getHolder() != null ? Objects.hashCode(p.getHolder().getValue()) : 0;
	}

	private static boolean notnull(ValueProperty p) {
		return p != null && p.getHolder() != null && p.getHolder().getValue() != null;
	}

	public static List<RefLink> createRefLinks(Property prop) {
		final List<RefLink> list = new LinkedList<>();
		if (prop.isRoot()) {
			for (Property p : prop.bundle().getAll()) {
				if (p.isRef()) {
					list.add(toRefLink(p));
				}
			}
		} else {
			prop.traverse(new PropertyVisitor() {
				@Override
				public void visit(Property p, String path, ElementType type) {
					throw new UnsupportedOperationException();
				}
				@Override
				public void visit(Property p, ElementType type) {
					if (p.isRef()) {
						list.add(toRefLink(p));
					}
				}
			}, false);
		}
		return list;
	}

	private static RefLink toRefLink(Property p) {
		RefProperty ref = p.asRef();
		RefLink link = new RefLink(ref);
		Property target = ref.getRefTarget();
		Property refContainer = ref.getContainer();
		// set ref position (if ref is a collection member)
		if (refContainer.isCollection()) {
			link.setRefIndex(refContainer.asCollection().getList().indexOf(ref));
		}
		link.setRefCanonicalPath(p.getCanonicalPath());
		link.setTargetCanonicalPath(target.getCanonicalPath());
		return link;
	}
}
