// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.cache;

import java.util.Objects;
import java.util.Optional;
import pl.decerto.hyperon.persistence.cache.metadata.BundleTableMetadataDto;
import pl.decerto.hyperon.persistence.cache.metadata.MetadataCache;
import pl.decerto.hyperon.persistence.model.def.BundleDef;
import pl.decerto.hyperon.persistence.model.value.Bundle;

/**
 * @author przemek hertel
 */
public class GmoCacheManager {
	@java.lang.SuppressWarnings("all")
	private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(GmoCacheManager.class);
	private final BundleCache bundleCache;
	private final DefinitionCache definitionCache;
	private final DatabaseFetchStatsCache statsCache;
	private final MetadataCache metadataCache;

	public GmoCacheManager(BundleCache bundleCache, DefinitionCache definitionCache, DatabaseFetchStatsCache statsCache) {
		this(bundleCache, definitionCache, statsCache, null);
	}

	public GmoCacheManager(BundleCache bundleCache, DefinitionCache definitionCache, DatabaseFetchStatsCache statsCache, MetadataCache metadataCache) {
		this.bundleCache = bundleCache;
		this.definitionCache = definitionCache;
		this.statsCache = statsCache;
		this.metadataCache = metadataCache;
	}

	public void invalidateAll() {
		log.debug("invalidating all persistence caches");
		bundleCache.clear();
		definitionCache.clear();
		statsCache.clear();
		if (Objects.nonNull(metadataCache)) {
			metadataCache.clear();
		}
	}

	public void addBundle(Bundle bundle) {
		log.debug("adding bundle id:{} to cache", bundle.getId());
		if (log.isTraceEnabled()) {
			log.trace("added bundle:{}", bundle);
		}
		bundleCache.put(bundle);
	}

	public Bundle getBundle(long id) {
		log.debug("checking bundle cache for bundle id:{}", id);
		Bundle bundle = bundleCache.get(id);
		if (log.isTraceEnabled()) {
			log.trace("fetched bundle from cache:{}", bundle);
		}
		log.debug("bundle id:{} found in cache:{}", id, Objects.nonNull(bundle));
		return bundle;
	}

	public void removeBundle(long id) {
		log.debug("removing bundle id:{} from cache", id);
		bundleCache.remove(id);
	}

	public void addDefinition(String profile, BundleDef def) {
		log.debug("adding bundle def from profile:{} to cache", profile);
		if (log.isTraceEnabled()) {
			log.trace("added bundle def:{}", def);
		}
		definitionCache.put(profile, def);
	}

	public Optional<BundleDef> getDefinition(String profile) {
		log.debug("get bundle definition from profile:{}", profile);
		Optional<BundleDef> def = definitionCache.get(profile);
		log.debug("bundle def for profile:{} found in cache:{}", profile, def.isPresent());
		return def;
	}

	public void addMetadata(String profile, BundleTableMetadataDto tableMetadata) {
		log.debug("adding column metadata for profile:{} to cache", profile);
		if (Objects.nonNull(metadataCache)) {
			metadataCache.put(profile, tableMetadata);
		} else {
			log.warn("trying to add metadata to uninitialized cache. Use correct method in HyperonPersistenceFactory to initialize it");
		}
	}

	@java.lang.SuppressWarnings("all")
	public DefinitionCache getDefinitionCache() {
		return this.definitionCache;
	}
}
