/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

public class WatcherConfig {
    public static final int DEFAULT_START_DELAY_SECONDS = 10;
    public static final int DEFAULT_WATCHER_PAUSE_SECONDS = 3;
    public static final int DEFAULT_ERROR_RECOVERY_SECONDS = 30;
    private int startDelaySeconds;
    private int watcherPauseSeconds;
    private int errorPauseSeconds;

    public WatcherConfig(int startDelaySeconds, int watcherPauseSeconds, int errorPauseSeconds) {
        this.startDelaySeconds = startDelaySeconds;
        this.watcherPauseSeconds = watcherPauseSeconds;
        this.errorPauseSeconds = errorPauseSeconds;
    }

    public WatcherConfig(int watcherPauseSeconds) {
        this(10, watcherPauseSeconds, 30);
    }

    public WatcherConfig() {
        this(3);
    }

    public WatcherConfig delay(int startDelaySeconds) {
        this.startDelaySeconds = startDelaySeconds;
        return this;
    }

    public WatcherConfig pause(int pauseSeconds) {
        this.watcherPauseSeconds = pauseSeconds;
        return this;
    }

    public WatcherConfig error(int errorSeconds) {
        this.errorPauseSeconds = errorSeconds;
        return this;
    }

    public int getStartDelaySeconds() {
        return this.startDelaySeconds;
    }

    public int getWatcherPauseSeconds() {
        return this.watcherPauseSeconds;
    }

    public int getErrorPauseSeconds() {
        return this.errorPauseSeconds;
    }

    public String toString() {
        return "delay: " + this.startDelaySeconds + "s, pause: " + this.watcherPauseSeconds + "s, error pause: " + this.errorPauseSeconds + "s";
    }
}

