/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.decerto.hyperon.runtime.sync.BaseWatcher;
import pl.decerto.hyperon.runtime.sync.Trackable;
import pl.decerto.hyperon.runtime.sync.event.ElementType;
import pl.decerto.hyperon.runtime.sync.event.EventType;
import pl.decerto.hyperon.runtime.sync.event.WatcherEvent;
import pl.decerto.hyperon.runtime.sync.event.WatcherEventListener;

public abstract class RuntimeWatcher
extends BaseWatcher
implements Runnable {
    protected Date timestamp;
    protected WatcherEventListener eventListener;
    protected List<WatcherEvent> events = new ArrayList<WatcherEvent>();
    private Date lastUpdate;

    @Override
    public void doWatch() {
        this.log.debug("checking cache accuracy");
        this.lastUpdate = this.getLastUpdate();
        if (this.log.isDebugEnabled()) {
            this.log.debug("fetched max last update:{}", (Object)this.print(this.lastUpdate));
        }
        if (this.possibleModification()) {
            this.checkPossibleModification();
        }
        this.log.debug("checking cache accuracy finished");
    }

    public void checkPossibleModification() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("newer last update: {}", (Object)this.print(this.lastUpdate));
        }
        List<Trackable> allFresh = this.getAllLastUpdates();
        List<Trackable> allCached = this.getAllCached();
        Map<Integer, Trackable> freshMap = this.toMap(allFresh);
        this.log.trace("fetched {} fresh elements", (Object)freshMap.size());
        this.invalidateOrReloadOldCache(allCached, freshMap);
        this.timestamp = this.lastUpdate;
        this.emitEvents();
        if (this.log.isDebugEnabled()) {
            this.log.debug("last update set to: {}", (Object)this.print(this.timestamp));
        }
    }

    private void invalidateOrReloadOldCache(List<Trackable> allCached, Map<Integer, Trackable> freshMap) {
        for (Trackable cached : allCached) {
            int id = cached.getId();
            Trackable fresh = freshMap.get(id);
            if (fresh == null) {
                this.log.info("{} removed, invalidating...", (Object)cached);
                this.invalidate(id);
                this.addEvent(EventType.REMOVED, id, cached.getCode(), this.lastUpdate);
                continue;
            }
            if (!this.isChanged(cached, fresh)) continue;
            this.log.info("{} is changed, reloading...", (Object)cached);
            String code = fresh.getCode();
            this.reloadExistingElement(fresh, code, id, cached);
            this.addEvent(EventType.CHANGED, id, cached.getCode(), fresh.getLastUpdate());
        }
    }

    private void reloadExistingElement(Trackable fresh, String code, int id, Trackable cachedTrackable) {
        this.log.info("[{} #{}] is out of date, reloading...", (Object)code, (Object)id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("  cached : {}", (Object)this.print(cachedTrackable));
            this.log.debug("  fresh  : {}", (Object)this.print(fresh));
        }
        this.invalidate(id);
        this.doReload(code);
    }

    private String print(Trackable t) {
        return t.getCode() + "#" + t.getId() + " / " + this.print(t.getLastUpdate());
    }

    private void doReload(String code) {
        long t = System.currentTimeMillis();
        this.reload(code);
        this.log.debug("reloaded: {}, time={}", (Object)code, (Object)(System.currentTimeMillis() - t));
    }

    public abstract void reload(String var1);

    public void setEventListener(WatcherEventListener listener) {
        this.eventListener = listener;
    }

    private Map<Integer, Trackable> toMap(List<Trackable> list) {
        HashMap<Integer, Trackable> map = new HashMap<Integer, Trackable>();
        for (Trackable t : list) {
            map.put(t.getId(), t);
        }
        return map;
    }

    private boolean possibleModification() {
        return this.lastUpdate != null && (this.timestamp == null || this.lastUpdate.getTime() > this.timestamp.getTime());
    }

    boolean isChanged(Trackable cached, Trackable fresh) {
        return this.isOutOfDate(cached, fresh);
    }

    private boolean isOutOfDate(Trackable cached, Trackable fresh) {
        boolean outOfDate = this.isOutOfDate(cached.getLastUpdate(), fresh.getLastUpdate());
        if (outOfDate) {
            this.log.info("cached element:{} is out of date, fresh date:{}", (Object)cached.getLastUpdate(), (Object)fresh.getLastUpdate());
        }
        return outOfDate;
    }

    private boolean isOutOfDate(Date cached, Date fresh) {
        if (fresh == null) {
            return false;
        }
        return cached == null || fresh.getTime() > cached.getTime();
    }

    Date getTimestamp() {
        return this.timestamp;
    }

    private void addEvent(EventType type, int id, String code, Date timestamp) {
        WatcherEvent event = new WatcherEvent(this.getElementType(), type);
        event.setId(id);
        event.setCode(code);
        event.setTimestamp(timestamp != null ? timestamp.getTime() : 0L);
        this.events.add(event);
    }

    private void emitEvents() {
        if (this.events.isEmpty()) {
            return;
        }
        this.log.debug("detected {} events", (Object)this.events.size());
        if (this.eventListener != null) {
            for (WatcherEvent event : this.events) {
                this.eventListener.onWatcherEvent(event);
            }
        }
        this.events.clear();
    }

    int getEventQueueSize() {
        return this.events.size();
    }

    public abstract Date getLastUpdate();

    public abstract List<Trackable> getAllLastUpdates();

    public abstract List<Trackable> getAllCached();

    public abstract void invalidate(int var1);

    public abstract ElementType getElementType();
}

