/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.smartparam.engine.core.prepared.CacheEntry;
import org.smartparam.engine.core.prepared.ParamPreparer;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import org.smartparam.engine.core.prepared.PreparedParameter;
import pl.decerto.hyperon.runtime.core.versioninterceptor.VersionInterceptor;
import pl.decerto.hyperon.runtime.exception.HyperonIllegalStateException;
import pl.decerto.hyperon.runtime.model.Parameter;
import pl.decerto.hyperon.runtime.prefetch.Initializer;
import pl.decerto.hyperon.runtime.provider.MpParameterProvider;
import pl.decerto.hyperon.runtime.sync.RuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.Trackable;
import pl.decerto.hyperon.runtime.sync.event.ElementType;

public class ParamRuntimeWatcher
extends RuntimeWatcher {
    private final MpParameterProvider provider;
    private final VersionInterceptor versionInterceptor;
    private final PreparedParamCache indexCache;
    private final ParamPreparer paramPreparer;
    private final boolean developerMode;
    private final Initializer initializer;

    public ParamRuntimeWatcher(MpParameterProvider provider, PreparedParamCache indexCache, VersionInterceptor versionInterceptor, ParamPreparer paramPreparer, boolean developerMode, Initializer initializer) {
        this.provider = provider;
        this.indexCache = indexCache;
        this.versionInterceptor = versionInterceptor;
        this.paramPreparer = paramPreparer;
        this.developerMode = developerMode;
        this.initializer = initializer;
    }

    @Override
    protected String getWatcherName() {
        return "param-watcher";
    }

    @Override
    public Date getLastUpdate() {
        return this.provider.getLastUpdate(this.developerMode);
    }

    @Override
    public List<Trackable> getAllLastUpdates() {
        return this.provider.getAllLastUpdates(this.developerMode);
    }

    @Override
    public List<Trackable> getAllCached() {
        List<CacheEntry<PreparedParameter>> all = this.indexCache.list();
        this.log.trace("fetched {} parameters from cache", (Object)all.size());
        ArrayList<Trackable> result = new ArrayList<Trackable>(all.size());
        for (CacheEntry<PreparedParameter> entry : all) {
            String key = entry.getKey();
            this.getMetadata(entry.getValue()).map(metadata -> new Trackable(metadata.getId(), key, metadata.getLastUpdate())).ifPresent(result::add);
        }
        return result;
    }

    @Override
    boolean isChanged(Trackable cached, Trackable fresh) {
        return super.isChanged(cached, fresh) || this.isMasterChanged(cached);
    }

    private boolean isMasterChanged(Trackable cached) {
        return this.getCachedParameter(cached).map(cachedParam -> cachedParam.isSlave() && this.isMasterUpdatedAfterSlaveLoad((Parameter)cachedParam)).orElse(true);
    }

    private Optional<Parameter> getCachedParameter(Trackable cached) {
        return this.getMetadata(this.indexCache.get(cached.getCode()));
    }

    private boolean isMasterUpdatedAfterSlaveLoad(Parameter slaveParameter) {
        return this.isMasterUpdatedAfterSlaveLoad(this.getMasterParameter(slaveParameter), slaveParameter);
    }

    private Parameter getMasterParameter(Parameter slaveParameter) {
        String masterUid = this.versionInterceptor.decorateParameterUid(slaveParameter.getMasterName());
        PreparedParameter masterFromCache = this.indexCache.get(masterUid);
        return Objects.isNull(masterFromCache) ? (Parameter)this.paramPreparer.getPreparedParameter(masterUid).getMetadata() : this.getMetadata(masterFromCache).orElseThrow(() -> new HyperonIllegalStateException("metadata cannot be null from not null prepared parameter"));
    }

    private boolean isMasterUpdatedAfterSlaveLoad(Parameter masterParameter, Parameter slaveParameter) {
        boolean masterUpdatedAfterSlaveLoad;
        boolean bl = masterUpdatedAfterSlaveLoad = !masterParameter.getLastUpdate().before(slaveParameter.getLoadedAt());
        if (masterUpdatedAfterSlaveLoad) {
            this.log.debug("cached slave parameter:{} must be invalidated, its master:{} was updated after slave load time", (Object)slaveParameter, (Object)masterParameter);
        }
        return masterUpdatedAfterSlaveLoad;
    }

    private Optional<Parameter> getMetadata(PreparedParameter masterParameter) {
        return Optional.ofNullable(masterParameter).map(mp -> (Parameter)mp.getMetadata());
    }

    @Override
    public void invalidate(int id) {
        this.indexCache.invalidate(id);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.PARAMETER;
    }

    @Override
    public void reload(String code) {
        this.initializer.initialize(code);
    }
}

