/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.exception.UnrecognizedDialectException;
import pl.decerto.hyperon.runtime.sql.DialectPrinter;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;
import pl.decerto.hyperon.runtime.sql.HyperonDialect;
import pl.decerto.hyperon.runtime.sql.dialect.DatabaseDialect;
import pl.decerto.hyperon.runtime.sql.dialect.DialectParser;
import pl.decerto.hyperon.runtime.sql.dialect.H2HyperonDialect;
import pl.decerto.hyperon.runtime.sql.dialect.HsqlHyperonDialect;
import pl.decerto.hyperon.runtime.sql.dialect.MsSQL2012HyperonDialect;
import pl.decerto.hyperon.runtime.sql.dialect.OracleHyperonDialect;
import pl.decerto.hyperon.runtime.sql.dialect.PostgresqlHyperonDialect;

public class DialectRegistry {
    private static final Logger log = LoggerFactory.getLogger(DialectRegistry.class);
    public static final HyperonDialect DEFAULT_DIALECT = new OracleHyperonDialect();
    private static Map<String, Object> dialects = new HashMap<String, Object>();
    private static final DialectTemplate template;

    public static void setup(HyperonDialect dialect) {
        template.setDialect(dialect);
        if (log.isInfoEnabled()) {
            log.info("Using Hyperon dialect: \n{}\n", (Object)DialectPrinter.print(dialect));
        }
    }

    private static void setupDialectClassName(String className) {
        log.info("using dialect class: {}", (Object)className);
        Class dialectClass = DialectRegistry.classForName(className);
        DialectRegistry.setup((HyperonDialect)DialectRegistry.createInstance(dialectClass));
    }

    public static void set(Object obj) {
        if (obj instanceof HyperonDialect) {
            DialectRegistry.setup((HyperonDialect)obj);
        } else if (obj instanceof String) {
            String code = (String)obj;
            Object value = dialects.get(code);
            if (value != null) {
                log.debug("dialect [{}] mapped to [{}]", (Object)code, value);
                if (value instanceof HyperonDialect) {
                    DialectRegistry.set(value);
                } else if (value instanceof String) {
                    DialectRegistry.setupDialectClassName(value.toString());
                } else {
                    throw new UnrecognizedDialectException(obj);
                }
                return;
            }
            DialectRegistry.setupDialectClassName(code);
        } else {
            throw new UnrecognizedDialectException(obj);
        }
    }

    @Deprecated
    public void setDialectByUrl(List<Object> objects) {
        String databaseDialect = DialectParser.getDatabaseDialect(objects);
        this.setDialect(databaseDialect);
    }

    public void setDialectByUrl(String jdbcUrl) {
        String databaseDialect = DialectParser.getDatabaseDialect(jdbcUrl);
        this.setDialect(databaseDialect);
    }

    public void setDialect(Object obj) {
        DialectRegistry.set(obj);
    }

    public static void setSchema(String schema) {
        template.setSchema(schema);
    }

    public void setDialects(Map<String, Object> dialects) {
        DialectRegistry.dialects.putAll(dialects);
    }

    public DialectTemplate create() {
        return template;
    }

    public static HyperonDialect getDialect() {
        return template.getDialect();
    }

    public static DialectTemplate getDialectTemplate() {
        return template;
    }

    public static HyperonDialect getDialectFor(String dialectName) {
        if (!dialects.containsKey(dialectName)) {
            throw new UnrecognizedDialectException((Object)dialectName);
        }
        return (HyperonDialect)dialects.get(dialectName);
    }

    static <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UnrecognizedDialectException((Object)className, (Throwable)e);
        }
    }

    static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new UnrecognizedDialectException(clazz, (Throwable)e);
        }
    }

    static void logRegisteredDialects() {
        log.debug("registered mpp dialects:");
        for (Map.Entry<String, Object> entry : dialects.entrySet()) {
            String code = entry.getKey();
            Object value = entry.getValue();
            String desc = value instanceof HyperonDialect ? value.getClass().getName() : String.valueOf(value);
            if (!log.isDebugEnabled()) continue;
            log.debug("  {} : {}", (Object)StringUtils.rightPad((String)code, (int)16), (Object)desc);
        }
    }

    static {
        dialects.put(DatabaseDialect.ORACLE.getDialect(), new OracleHyperonDialect());
        dialects.put(DatabaseDialect.HSQLAB.getDialect(), new HsqlHyperonDialect());
        dialects.put(DatabaseDialect.H2.getDialect(), new H2HyperonDialect());
        dialects.put(DatabaseDialect.MSSQL2012.getDialect(), new MsSQL2012HyperonDialect());
        dialects.put(DatabaseDialect.POSTGRESQL.getDialect(), new PostgresqlHyperonDialect());
        DialectRegistry.logRegisteredDialects();
        template = new DialectTemplate();
    }
}

