/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino.domain;

import java.math.BigDecimal;
import java.util.Date;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.runtime.core.EmptyParamValue;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.helper.TypeConverter;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.rhino.value.RhinoEmptyValue;
import pl.decerto.hyperon.runtime.rhino.value.RhinoParamValue;

public class RhinoDomainAttribute {
    private static final HyperonContext EMPTY_CTX = new HyperonContext(new Object[0]);
    private static final EmptyParamValue EMPTY_PV = new EmptyParamValue();
    private static final RhinoEmptyValue EMPTY_RPV = new RhinoEmptyValue();
    private static TypeConverter type = new TypeConverter();
    private final HyperonDomainAttribute attr;
    private final HyperonContext ctx;

    public RhinoDomainAttribute(HyperonDomainAttribute attr, HyperonContext ctx) {
        this.attr = attr;
        this.ctx = this.notnull(ctx);
    }

    public RhinoParamValue getValue(HyperonContext ctx) {
        ParamValue pv = this.getParamValue(ctx);
        return pv != null ? new RhinoParamValue(pv) : EMPTY_RPV;
    }

    public RhinoParamValue getValue() {
        return this.getValue(this.ctx);
    }

    public String getString(HyperonContext ctx) {
        return type.getString(this.value(ctx));
    }

    public String getString() {
        return this.getString(this.ctx);
    }

    public double getNumber(HyperonContext ctx) {
        return type.getNumber(this.value(ctx));
    }

    public double getNumber() {
        return this.getNumber(this.ctx);
    }

    public BigDecimal getDecimal(HyperonContext ctx) {
        return type.getDecimal(this.value(ctx));
    }

    public BigDecimal getDecimal() {
        return this.getDecimal(this.ctx);
    }

    public Integer getInteger(HyperonContext ctx) {
        return type.getInteger(this.value(ctx));
    }

    public Integer getInteger() {
        return this.getInteger(this.ctx);
    }

    public Date getDate(HyperonContext ctx) {
        return type.getDate(this.value(ctx));
    }

    public Date getDate() {
        return this.getDate(this.ctx);
    }

    public boolean getBoolean(HyperonContext ctx) {
        return type.getBoolean(this.value(ctx));
    }

    public boolean getBoolean() {
        return this.getBoolean(this.ctx);
    }

    public Object value(HyperonContext ctx) {
        ValueHolder holder = this.getParamValue(ctx).getHolder();
        return holder != null ? holder.getValue() : null;
    }

    public ParamValue getParamValue(HyperonContext ctx) {
        return this.attr != null ? this.attr.getValue(ctx, new Object[0]) : EMPTY_PV;
    }

    public ParamValue getParamValue() {
        return this.getParamValue(this.ctx);
    }

    public String getDigest() {
        return this.attr != null ? this.attr.getDigest() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RhinoDomainAttribute[");
        if (this.attr != null) {
            sb.append(this.attr.getCode()).append('=').append(this.attr.getRawValue());
        }
        sb.append(']');
        return sb.toString();
    }

    private HyperonContext notnull(HyperonContext ctx) {
        return ctx != null ? ctx : EMPTY_CTX;
    }
}

