/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.provider;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.context.LevelValuesFlattener;
import org.smartparam.engine.core.parameter.ParamRepository;
import org.smartparam.engine.core.parameter.ParameterBatchLoader;
import org.smartparam.engine.core.parameter.ParameterEntry;
import pl.decerto.hyperon.runtime.core.extdatasource.ExternalDataSourceProvider;
import pl.decerto.hyperon.runtime.dao.external.ExternalStorageDao;
import pl.decerto.hyperon.runtime.dao.parameter.ParameterJdbcDao;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.distinct.DistinctFilter;
import pl.decerto.hyperon.runtime.helper.MpHelper;
import pl.decerto.hyperon.runtime.helper.uid.Uid;
import pl.decerto.hyperon.runtime.helper.uid.UidParser;
import pl.decerto.hyperon.runtime.model.Parameter;
import pl.decerto.hyperon.runtime.profiler.engine.EngineProfiler;
import pl.decerto.hyperon.runtime.provider.external.ExtSqlExecutor;
import pl.decerto.hyperon.runtime.sync.PidCache;
import pl.decerto.hyperon.runtime.sync.Trackable;

public class MpParameterProvider
implements ParamRepository {
    private static final Logger log = LoggerFactory.getLogger(MpParameterProvider.class);
    private static final EngineProfiler profiler = EngineProfiler.PARAMETER;
    private final ParameterJdbcDao dao;
    private final ExternalStorageDao externalDao;
    private final MpHelper helper = new MpHelper();
    private final DistinctFilter distinct = new DistinctFilter();
    private final PidCache pidCache = new PidCache();
    private final int maxConcurrentLoads;
    private final AtomicInteger concurrentLoadCounter = new AtomicInteger();
    private final Semaphore semaphore;
    private final ExtSqlExecutor extSqlExecutor;

    public MpParameterProvider(ParameterJdbcDao dao, ExternalStorageDao externalDao, int maxConcurrentLoads, ExternalDataSourceProvider externalDataSourceProvider, ConnectionInterceptor connectionInterceptor) {
        this.dao = dao;
        this.externalDao = externalDao;
        this.maxConcurrentLoads = maxConcurrentLoads;
        this.semaphore = new Semaphore(this.maxConcurrentLoads, true);
        this.extSqlExecutor = new ExtSqlExecutor(externalDataSourceProvider, connectionInterceptor);
    }

    public MpParameterProvider(ParameterJdbcDao dao, ExternalStorageDao externalDao, int maxConcurrentLoads) {
        this(dao, externalDao, maxConcurrentLoads, null, null);
    }

    public MpParameterProvider(ParameterJdbcDao dao, ExternalStorageDao externalDao) {
        this(dao, externalDao, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.smartparam.engine.core.parameter.Parameter load(String uid) {
        long t = System.currentTimeMillis();
        try {
            org.smartparam.engine.core.parameter.Parameter parameter = this.loadWithQueue(uid);
            return parameter;
        }
        finally {
            profiler.addLoadMeasure(uid, t, System.currentTimeMillis());
        }
    }

    private org.smartparam.engine.core.parameter.Parameter _load(String uid) {
        log.debug("enter load, uid={}", (Object)uid);
        Parameter p = this.doLoad(uid);
        if (p != null) {
            if (p.hasExternalStorage()) {
                this.externalDao.resolveExternalValues(p);
            }
            if (p.isDistinct()) {
                this.distinct.filter(p);
            }
            Parameter metadata = this.helper.copyDefinition(p);
            this.pidCache.set(p.getId(), metadata);
            p.setMetadata(metadata);
        }
        return p;
    }

    private org.smartparam.engine.core.parameter.Parameter loadWithQueue(String uid) {
        try {
            this.semaphore.acquireUninterruptibly();
            this.concurrentLoadCounter.incrementAndGet();
            org.smartparam.engine.core.parameter.Parameter parameter = this._load(uid);
            return parameter;
        }
        finally {
            this.concurrentLoadCounter.decrementAndGet();
            this.semaphore.release();
        }
    }

    private Parameter doLoad(String uid) {
        Uid spec = UidParser.parseUid(uid);
        return this.dao.getParameter(spec.getCode(), spec.getVersion(), spec.getSid(), spec.getMid());
    }

    public Date getLastUpdate() {
        return this.dao.getMaxLastUpdate();
    }

    public Date getLastUpdate(boolean developerMode) {
        return this.dao.getMaxLastUpdate(developerMode);
    }

    public List<Trackable> getAllLastUpdates(boolean developerMode) {
        return this.dao.getAllLastUpdates(developerMode);
    }

    @Override
    public Collection<ParameterEntry> findEntries(int pid, String[][] inputLevels) {
        Parameter def = this.pidCache.get(pid);
        if (def.isExternalSource()) {
            String[] flattenInput = LevelValuesFlattener.flatten(inputLevels);
            return this.extSqlExecutor.findEntries(def, flattenInput);
        }
        Collection<ParameterEntry> result = this.dao.findEntries(pid, inputLevels);
        if (def.hasExternalStorage()) {
            this.externalDao.resolveExternalValues(def, result);
        }
        return result;
    }

    @Override
    public ParameterBatchLoader batchLoad(String parameterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listParameters() {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfLoadsInProgress() {
        return this.concurrentLoadCounter.get();
    }

    public PidCache getPidCache() {
        return this.pidCache;
    }

    public int getMaxConcurrentLoads() {
        return this.maxConcurrentLoads;
    }
}

