/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.profiler.jdbc.proxy;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.profiler.jdbc.proxy.ConnectionProxy;

public class DataSourceProxy
implements DataSource {
    private static final Logger log = LoggerFactory.getLogger(DataSourceProxy.class);
    private DataSource dataSource;

    public DataSourceProxy(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        log.debug("creating DataSourceProxy for: {}", (Object)dataSource);
        this.logProperties();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ConnectionProxy.newInstance(this.dataSource.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return ConnectionProxy.newInstance(this.dataSource.getConnection(username, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return null;
    }

    private void logProperties() {
        try {
            this._logProperties();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.info("cannot log datasource properties: {}", (Object)e.getMessage());
            log.trace("cause", (Throwable)e);
        }
    }

    private void _logProperties() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String datasourceClassName = this.dataSource.getClass().getName();
        if (datasourceClassName.equals("com.mchange.v2.c3p0.ComboPooledDataSource")) {
            log.info("datasource jdbc url: {}", this.useGetter(this.dataSource, "getJdbcUrl"));
            log.info("datasource username: {}", this.useGetter(this.dataSource, "getUser"));
        }
    }

    private Object useGetter(Object obj, String getterName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return obj.getClass().getMethod(getterName, new Class[0]).invoke(obj, new Object[0]);
    }

    public String toString() {
        return "DataSourceProxy[ " + this.dataSource + " ]";
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSourceProxy() {
    }
}

