/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.math.BigDecimal;
import java.util.Date;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.domain.AttributeValueProvider;
import pl.decerto.hyperon.runtime.helper.TypeConverter;
import pl.decerto.hyperon.runtime.model.DomainAttributeDto;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;
import pl.decerto.hyperon.runtime.model.Type;
import pl.decerto.hyperon.runtime.profiler.attribute.AttributeKey;
import pl.decerto.hyperon.runtime.profiler.engine.AttributeEngineProfiler;

public class HyperonDomainAttribute {
    private static final TypeConverter type = new TypeConverter();
    private static final AttributeEngineProfiler DOMAIN_PROFILER = AttributeEngineProfiler.DOMAIN;
    private final DomainAttributeDto attribute;
    private final HyperonDomainObject object;
    private final AttributeValueProvider valueProvider;

    public int getId() {
        return this.attribute.getId();
    }

    public String getCode() {
        return this.attribute.getCode();
    }

    public String getName() {
        return this.attribute.getName();
    }

    public String getDescription() {
        return this.attribute.getDescription();
    }

    public String getRawValue() {
        return this.attribute.getRawValue();
    }

    public Type getRawType() {
        return this.attribute.getRawType();
    }

    public HyperonDomainObjectType getDomainType() {
        return this.attribute.getDomainType();
    }

    public HyperonDomainObject getDomainObject() {
        return this.object;
    }

    public int getDomainObjectId() {
        return this.attribute.getDomainObjectId();
    }

    public String getType() {
        return this.attribute.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamValue getValue(ParamContext ctx, Object ... args) {
        long start = System.currentTimeMillis();
        try {
            ParamValue paramValue = this.valueProvider.getValue(this, ctx, args);
            return paramValue;
        }
        finally {
            DOMAIN_PROFILER.addInvokeMeasure(new AttributeKey(this.object.getPath(), this.attribute.getCode()), start, System.currentTimeMillis());
        }
    }

    public String getString(HyperonContext ctx) {
        return type.getString(this.holder(ctx));
    }

    public BigDecimal getDecimal(HyperonContext ctx) {
        return type.getDecimal(this.holder(ctx));
    }

    public double getNumber(HyperonContext ctx) {
        return type.getNumber(this.holder(ctx));
    }

    public Integer getInteger(HyperonContext ctx) {
        return type.getInteger(this.holder(ctx));
    }

    public Long getLong(HyperonContext ctx) {
        return type.getLong(this.holder(ctx));
    }

    public Date getDate(HyperonContext ctx) {
        return type.getDate(this.holder(ctx));
    }

    public Boolean getBoolean(HyperonContext ctx) {
        return type.toBooleanHolder(this.holder(ctx)).getBoolean();
    }

    public ValueHolder getHolder(HyperonContext ctx) {
        return this.holder(ctx);
    }

    public double doubleValue(HyperonContext ctx) {
        return type.getNumber(this.holder(ctx));
    }

    public int intValue(HyperonContext ctx) {
        return type.toIntegerHolder(this.holder(ctx)).intValue();
    }

    public long longValue(HyperonContext ctx) {
        return type.toIntegerHolder(this.holder(ctx)).longValue();
    }

    public boolean booleanValue(HyperonContext ctx) {
        return type.toBooleanHolder(this.holder(ctx)).booleanValue();
    }

    private ValueHolder holder(HyperonContext ctx) {
        return this.getValue(ctx, new Object[0]).getHolder();
    }

    public String getDigest() {
        return this.valueProvider.getDigest(this.attribute.getRawType(), this.attribute.getRawValue());
    }

    public String toString() {
        return "HypDomainAttr[" + this.attribute.getCode() + ": " + this.attribute.getRawValue() + "]";
    }

    public HyperonDomainAttribute(DomainAttributeDto attribute, HyperonDomainObject object, AttributeValueProvider valueProvider) {
        this.attribute = attribute;
        this.object = object;
        this.valueProvider = valueProvider;
    }

    public DomainAttributeDto getAttribute() {
        return this.attribute;
    }

    public AttributeValueProvider getValueProvider() {
        return this.valueProvider;
    }
}

