/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.Date;
import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevel;
import pl.decerto.hyperon.runtime.helper.StrUtil;
import pl.decerto.hyperon.runtime.model.Function;
import pl.decerto.hyperon.runtime.utils.hash.HashUtils;

public class GroovyFunction
extends Function {
    private static final String[] EMPTY_ARGS = new String[0];
    private String args;
    private String body;
    private String[] argsArray = EMPTY_ARGS;
    private String virtualName;

    public GroovyFunction(int id, int implId, String code, String args, String body, Date lastupdate, FunctionLogLevel logLevel) {
        super(id, implId, code, "groovy", lastupdate, logLevel);
        this.initialize(args, body);
    }

    public GroovyFunction(int id, int implId, String code, String args, String body) {
        super(id, implId, code, "groovy");
        this.initialize(args, body);
    }

    public GroovyFunction(String code) {
        super(0, 0, code, "groovy");
        this.virtualName = this.createVirtualName();
    }

    private void initialize(String args, String body) {
        this.virtualName = this.createVirtualName();
        this.withArgs(args);
        this.withBody(body);
    }

    public GroovyFunction withArgs(String args) {
        this.args = args;
        this.createArgsArray();
        return this;
    }

    public GroovyFunction withBody(String body) {
        this.body = body;
        return this;
    }

    private void createArgsArray() {
        if (StrUtil.isEmpty(this.args)) {
            this.argsArray = EMPTY_ARGS;
        } else {
            this.argsArray = EngineUtil.split(this.args, ',');
            for (int i = 0; i < this.argsArray.length; ++i) {
                this.argsArray[i] = this.argsArray[i].trim();
            }
        }
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    private String createVirtualName() {
        StringBuilder sb = new StringBuilder(this.getName().length() + 30);
        sb.append("g_");
        sb.append(this.getId()).append('_');
        sb.append(this.getImplId()).append('_');
        String code = this.getName();
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            sb.append(this.escape(c));
        }
        return sb.toString();
    }

    private char escape(char c) {
        return (char)(Character.isLetter((char)c) || Character.isDigit((char)c) ? c : 95);
    }

    @Override
    public String getDigest() {
        String[] data = new String[]{this.getCode(), this.getType(), this.body};
        return HashUtils.sha1(data);
    }

    @Override
    public String getArgs() {
        return this.args;
    }

    public String getBody() {
        return this.body;
    }

    public String[] getArgsArray() {
        return this.argsArray;
    }
}

