/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.level;

import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.decoder.ValueDecoder;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.level.OutputLevelArraySeparator;

public class LevelArraySplitter {
    public ValueHolder[] split(String value, SplitConfiguration splitConfiguration, DecoderConfiguration decoderConfiguration) {
        Type<?> type = splitConfiguration.type;
        char separator = splitConfiguration.arraySeparator.getSeparator();
        if (EngineUtil.hasText(value)) {
            String[] tokens = EngineUtil.split(value, separator);
            ValueHolder[] array = type.newArray(tokens.length);
            for (int i = 0; i < tokens.length; ++i) {
                array[i] = this.decode(decoderConfiguration, type, tokens[i]);
            }
            return array;
        }
        return type.newArray(0);
    }

    private ValueHolder decode(DecoderConfiguration decoderConfiguration, Type<?> type, String token) {
        return decoderConfiguration.decoder.decode(token, type, decoderConfiguration.ctx);
    }

    public static class DecoderConfiguration {
        private final ValueDecoder decoder;
        private final ParamContext ctx;

        public DecoderConfiguration(ValueDecoder decoder, ParamContext ctx) {
            this.decoder = decoder;
            this.ctx = ctx;
        }
    }

    public static class SplitConfiguration {
        private final Type<?> type;
        private final OutputLevelArraySeparator arraySeparator;

        public SplitConfiguration(Type<?> type, OutputLevelArraySeparator arraySeparator) {
            this.type = type;
            this.arraySeparator = arraySeparator;
        }
    }
}

