/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.model.PythonFunction;

public final class PythonPreprocessor {
    private static final String FUNCTION_PREFIX_TEMPLATE = "def %s(%s):";

    public String apply(PythonFunction pythonFunction) {
        String beforeTrimming = this.getFunctionPrefix(pythonFunction.getName(), pythonFunction.getArgs()) + this.indentBody(pythonFunction.getBody());
        return beforeTrimming.trim();
    }

    public String apply(String functionName, String args, String body) {
        String beforeTrimming = this.getFunctionPrefix(functionName, args) + this.indentBody(body);
        return beforeTrimming.trim();
    }

    private String getFunctionPrefix(String name, String args) {
        return String.format(FUNCTION_PREFIX_TEMPLATE, this.getNormalizedName(name), args) + System.lineSeparator();
    }

    private String indentBody(String body) {
        BufferedReader reader = new BufferedReader(new StringReader(body));
        return reader.lines().map(line -> String.format("\t%s" + System.lineSeparator(), line)).collect(Collectors.joining());
    }

    private String getNormalizedName(String name) {
        return StringUtils.replaceChars((String)name, (char)'.', (char)'_');
    }
}

